/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.url.URLStreamHandlerService;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.ProjectAwareUrlStreamHandlerService;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModel;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.NamespaceManager;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.ProjectClasspathNamespaceDefinitionResolverCache;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionListener;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionResolver;
import org.springframework.ide.eclipse.core.MessageUtils;

public class BeansCorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.beans.core";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.beans.core.messages";
    public static final String IGNORE_MISSING_NAMESPACEHANDLER_PROPERTY = "ignoreMissingNamespaceHandler";
    public static final boolean IGNORE_MISSING_NAMESPACEHANDLER_PROPERTY_DEFAULT = false;
    public static final String LOAD_NAMESPACEHANDLER_FROM_CLASSPATH_ID = "loadNamespaceHandlerFromClasspath";
    public static final String DISABLE_CACHING_FOR_NAMESPACE_LOADING_ID = "disableCachingForNamespaceLoadingFromClasspath";
    public static final String TIMEOUT_CONFIG_LOADING_PREFERENCE_ID = "org.springframework.ide.eclipse.beans.core.timeoutConfigLoading";
    public static final String PROJECT_PROPERTY_ID = "enable.project.preferences";
    public static final String NAMESPACE_DEFAULT_VERSION_PREFERENCE_ID = "default.version.";
    public static final String NAMESPACE_PREFIX_PREFERENCE_ID = "prefix.";
    public static final String NAMESPACE_DEFAULT_FROM_CLASSPATH_ID = "default.version.check.classpath";
    private static BeansCorePlugin plugin;
    private BeansModel model;
    private NamespaceManager nsManager;
    private NamespaceBundleLister nsListener;
    private ServiceRegistration<?> projectAwareUrlService = null;
    private ExecutorService executorService;
    private AtomicInteger threadCount = new AtomicInteger(0);
    private static final String THREAD_NAME_TEMPLATE = "Background Thread-%s (%s/%s.%s.%s)";
    public static final String DISABLE_AUTO_DETECTION;
    private ResourceBundle resourceBundle;
    private volatile Set<INamespaceDefinitionListener> namespaceDefinitionListeners = Collections.synchronizedSet(new HashSet());
    private volatile boolean isClosed = false;
    private final transient Object monitor = new Object();

    static {
        DISABLE_AUTO_DETECTION = String.valueOf(BeansCorePlugin.class.getName()) + ".DISABLE_AUTO_DETECTION";
    }

    public BeansCorePlugin() {
        plugin = this;
        this.model = new BeansModel();
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("url.handler.protocol", "project-aware");
        this.projectAwareUrlService = context.registerService(URLStreamHandlerService.class.getName(), (Object)new ProjectAwareUrlStreamHandlerService(), properties);
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Version version = Version.parseVersion((String)BeansCorePlugin.getPluginVersion());
                String productId = "Spring IDE";
                IProduct product = Platform.getProduct();
                if (product != null && "com.springsource.sts".equals(product.getId())) {
                    productId = "STS";
                }
                Thread reportingThread = new Thread(runnable, String.format(BeansCorePlugin.THREAD_NAME_TEMPLATE, BeansCorePlugin.this.threadCount.incrementAndGet(), productId, version.getMajor(), version.getMinor(), version.getMicro()));
                reportingThread.setDaemon(true);
                return reportingThread;
            }
        });
        this.nsManager = new NamespaceManager(context);
        this.getPreferenceStore().setDefault(TIMEOUT_CONFIG_LOADING_PREFERENCE_ID, 60);
        this.getPreferenceStore().setDefault(NAMESPACE_DEFAULT_FROM_CLASSPATH_ID, true);
        this.getPreferenceStore().setDefault(LOAD_NAMESPACEHANDLER_FROM_CLASSPATH_ID, true);
        Job modelJob = new Job("Initializing Spring Tooling"){

            protected IStatus run(IProgressMonitor monitor) {
                BeansCorePlugin.this.initNamespaceHandlers(context);
                BeansCorePlugin.this.model.start();
                return Status.OK_STATUS;
            }
        };
        modelJob.setRule(MultiRule.combine((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), (ISchedulingRule)BeansCoreUtils.BEANS_MODEL_INIT_RULE));
        modelJob.setPriority(50);
        modelJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.model.stop();
        if (this.projectAwareUrlService != null) {
            this.projectAwareUrlService.unregister();
        }
        super.stop(context);
    }

    public static BeansCorePlugin getDefault() {
        return plugin;
    }

    public static IBeansModel getModel() {
        return BeansCorePlugin.getDefault().model;
    }

    public static void setModel(BeansModel model) {
        BeansCorePlugin.getDefault().model = model;
    }

    public static NamespaceHandlerResolver getNamespaceHandlerResolver() {
        return BeansCorePlugin.getDefault().nsManager.getNamespacePlugins();
    }

    public static INamespaceDefinitionResolver getNamespaceDefinitionResolver() {
        return BeansCorePlugin.getDefault().nsManager.getNamespacePlugins();
    }

    public static INamespaceDefinitionResolver getNamespaceDefinitionResolver(IProject project) {
        if (project != null) {
            return ProjectClasspathNamespaceDefinitionResolverCache.getResolver(project);
        }
        return BeansCorePlugin.getDefault().nsManager.getNamespacePlugins();
    }

    public static ExecutorService getExecutorService() {
        return BeansCorePlugin.getDefault().executorService;
    }

    public static void notifyNamespaceDefinitionListeners(IProject project) {
        for (INamespaceDefinitionListener listener : BeansCorePlugin.getDefault().namespaceDefinitionListeners) {
            listener.onNamespaceDefinitionRegistered(new INamespaceDefinitionListener.NamespaceDefinitionChangeEvent(null, project));
        }
    }

    public static void registerNamespaceDefinitionListener(INamespaceDefinitionListener listener) {
        BeansCorePlugin.getDefault().nsManager.getNamespacePlugins().registerNamespaceDefinitionListener(listener);
        BeansCorePlugin.getDefault().namespaceDefinitionListeners.add(listener);
    }

    public static void unregisterNamespaceDefinitionListener(INamespaceDefinitionListener listener) {
        BeansCorePlugin.getDefault().nsManager.getNamespacePlugins().unregisterNamespaceDefinitionListener(listener);
        BeansCorePlugin.getDefault().namespaceDefinitionListeners.remove(listener);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = BeansCorePlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                BeansCorePlugin.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public static ClassLoader getClassLoader() {
        return BeansCorePlugin.class.getClassLoader();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void log(IStatus status) {
        BeansCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = BeansCorePlugin.createErrorStatus(message, exception);
        BeansCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        BeansCorePlugin.getDefault().getLog().log(BeansCorePlugin.createErrorStatus(BeansCorePlugin.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static String getFormattedMessage(String key, Object ... args) {
        return MessageUtils.format((String)BeansCorePlugin.getResourceString(key), (Object[])args);
    }

    public static String getPluginVersion() {
        Bundle bundle = BeansCorePlugin.getDefault().getBundle();
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    protected void maybeAddNamespaceHandlerFor(Bundle bundle, boolean isLazy) {
        this.nsManager.maybeAddNamespaceHandlerFor(bundle, isLazy);
    }

    protected void maybeRemoveNameSpaceHandlerFor(Bundle bundle) {
        this.nsManager.maybeRemoveNameSpaceHandlerFor(bundle);
    }

    protected void initNamespaceHandlers(BundleContext context) {
        this.nsListener = new NamespaceBundleLister();
        context.addBundleListener((BundleListener)this.nsListener);
        Bundle[] previousBundles = context.getBundles();
        int i = 0;
        while (i < previousBundles.length) {
            Bundle bundle = previousBundles[i];
            if (this.isBundleResolved(bundle)) {
                this.nsManager.maybeAddNamespaceHandlerFor(bundle, false);
            } else if (this.isBundleLazyActivated(bundle)) {
                this.nsManager.maybeAddNamespaceHandlerFor(bundle, true);
            }
            ++i;
        }
        this.nsManager.afterPropertiesSet();
    }

    public boolean isBundleResolved(Bundle bundle) {
        return bundle.getState() >= 4;
    }

    public boolean isBundleLazyActivated(Bundle bundle) {
        Dictionary headers;
        if (bundle.getState() == 8 && (headers = bundle.getHeaders()) != null && headers.get("Bundle-ActivationPolicy") != null) {
            String value = ((String)headers.get("Bundle-ActivationPolicy")).trim();
            return value.startsWith("lazy");
        }
        return false;
    }

    public boolean isAutoDetectionEnabled() {
        return !this.getPreferenceStore().getBoolean(DISABLE_AUTO_DETECTION);
    }

    private abstract class BaseListener
    implements BundleListener {
        protected Map<Bundle, Object> lazyBundleCache = new WeakHashMap<Bundle, Object>();
        private final Object VALUE = new Object();

        private BaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void push(Bundle bundle) {
            Map<Bundle, Object> map = this.lazyBundleCache;
            synchronized (map) {
                this.lazyBundleCache.put(bundle, this.VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean pop(Bundle bundle) {
            Map<Bundle, Object> map = this.lazyBundleCache;
            synchronized (map) {
                return this.lazyBundleCache.remove(bundle) != null;
            }
        }

        public void bundleChanged(BundleEvent event) {
            if (BeansCorePlugin.this.isClosed) {
                return;
            }
            try {
                this.handleEvent(event);
            }
            catch (Exception ex) {
                BeansCorePlugin.log(ex);
            }
        }

        protected abstract void handleEvent(BundleEvent var1);
    }

    private class NamespaceBundleLister
    extends BaseListener {
        private NamespaceBundleLister() {
        }

        @Override
        protected void handleEvent(BundleEvent event) {
            Bundle bundle = event.getBundle();
            switch (event.getType()) {
                case 512: {
                    this.push(bundle);
                    BeansCorePlugin.this.maybeAddNamespaceHandlerFor(bundle, true);
                    break;
                }
                case 32: {
                    if (this.pop(bundle)) break;
                    BeansCorePlugin.this.maybeAddNamespaceHandlerFor(bundle, false);
                    break;
                }
                case 4: {
                    this.pop(bundle);
                    BeansCorePlugin.this.maybeRemoveNameSpaceHandlerFor(bundle);
                    break;
                }
            }
        }
    }
}

