/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.osgi.framework.Bundle;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.BundleDelegatingClassLoader;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.LazyBundleRegistry;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NamespacePlugins
implements NamespaceHandlerResolver,
EntityResolver,
DisposableBean {
    private final LazyBundleRegistry.Activator<Plugin> activation = new LazyBundleRegistry.Activator<Plugin>(){

        @Override
        public Plugin activate(Bundle bundle) {
            return new Plugin(bundle);
        }
    };
    final LazyBundleRegistry.Condition condition = new LazyBundleRegistry.Condition(){
        private final String NS_HANDLER_RESOLVER_CLASS_NAME = NamespaceHandlerResolver.class.getName();

        @Override
        public boolean pass(Bundle bundle) {
            try {
                Class type = bundle.loadClass(this.NS_HANDLER_RESOLVER_CLASS_NAME);
                return NamespaceHandlerResolver.class.equals((Object)type);
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    };
    private final LazyBundleRegistry<Plugin> pluginRegistry = new LazyBundleRegistry<Plugin>(this.condition, this.activation);

    public void destroy() {
        this.pluginRegistry.clear();
    }

    public NamespaceHandler resolve(final String namespaceUri) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<NamespaceHandler>(){

                @Override
                public NamespaceHandler run() {
                    return NamespacePlugins.this.doResolve(namespaceUri);
                }
            });
        }
        return this.doResolve(namespaceUri);
    }

    @Override
    public InputSource resolveEntity(final String publicId, final String systemId) throws SAXException, IOException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<InputSource>(){

                    @Override
                    public InputSource run() throws Exception {
                        return NamespacePlugins.this.doResolveEntity(publicId, systemId);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception cause = pae.getException();
                this.handleInputSourceException(cause);
            }
        } else {
            try {
                return this.doResolveEntity(publicId, systemId);
            }
            catch (Exception ex) {
                this.handleInputSourceException(ex);
            }
        }
        return null;
    }

    private NamespaceHandler doResolve(final String namespaceUri) {
        try {
            return this.pluginRegistry.apply(new LazyBundleRegistry.Operation<Plugin, NamespaceHandler>(){

                @Override
                public NamespaceHandler operate(Plugin plugin) {
                    try {
                        NamespaceHandler handler = plugin.resolve(namespaceUri);
                        if (handler != null) {
                            return handler;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    return null;
                }
            });
        }
        catch (Exception ex) {
            throw (RuntimeException)ex;
        }
    }

    private InputSource doResolveEntity(final String publicId, final String systemId) throws Exception {
        if (systemId != null) {
            return this.pluginRegistry.apply(new LazyBundleRegistry.Operation<Plugin, InputSource>(){

                @Override
                public InputSource operate(Plugin plugin) throws SAXException, IOException {
                    try {
                        InputSource inputSource = plugin.resolveEntity(publicId, systemId);
                        if (inputSource != null) {
                            return inputSource;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                    return null;
                }
            });
        }
        return null;
    }

    private void handleInputSourceException(Exception exception) throws SAXException, IOException {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (SAXException)exception;
    }

    void addPlugin(Bundle bundle, boolean lazyBundle, boolean applyCondition) {
        this.pluginRegistry.add(bundle, lazyBundle, applyCondition);
    }

    boolean isTypeCompatible(Bundle bundle) {
        return this.condition.pass(bundle);
    }

    boolean removePlugin(Bundle bundle) {
        return this.pluginRegistry.remove(bundle);
    }

    private static class Plugin
    implements NamespaceHandlerResolver,
    EntityResolver {
        private final EntityResolver entity;
        private final NamespaceHandlerResolver namespace;

        private Plugin(Bundle bundle) {
            BundleDelegatingClassLoader loader = BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle);
            this.entity = new DelegatingEntityResolver((ClassLoader)loader);
            this.namespace = new DefaultNamespaceHandlerResolver((ClassLoader)loader);
        }

        public NamespaceHandler resolve(String namespaceUri) {
            return this.namespace.resolve(namespaceUri);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return this.entity.resolveEntity(publicId, systemId);
        }
    }
}

