/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.process.BeansConfigPostProcessingContext;
import org.springframework.ide.eclipse.beans.core.internal.model.process.BeansConfigRegistrationSupport;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigPostProcessingContext;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigPostProcessor;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;

public class BeansConfigPostProcessorFactory {
    public static final String POSTPROCESSOR_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.core.postprocessors";

    public static IBeansConfigPostProcessor[] createPostProcessor(String type) {
        HashSet<IBeansConfigPostProcessor> postProcessors = new HashSet<IBeansConfigPostProcessor>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POSTPROCESSOR_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String extensionType = config.getAttribute("type");
                    if (type == null && extensionType == null || type != null && type.equals(extensionType)) {
                        try {
                            Object object = config.createExecutableExtension("class");
                            if (object instanceof IBeansConfigPostProcessor) {
                                IBeansConfigPostProcessor postProcessor = (IBeansConfigPostProcessor)object;
                                postProcessors.add(postProcessor);
                            }
                        }
                        catch (CoreException e) {
                            BeansCorePlugin.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return postProcessors.toArray(new IBeansConfigPostProcessor[postProcessors.size()]);
    }

    public static IBeansConfigPostProcessingContext createPostProcessingContext(IBeansConfig beansConfig, Collection<IBean> beans, ReaderEventListener readerEventListener, ProblemReporter problemReporter, BeanNameGenerator beanNameGenerator, BeanDefinitionRegistry beanDefinitionRegistry, Set<ValidationProblem> problems) {
        ArrayList<IBean> beansClone = new ArrayList<IBean>();
        beansClone.addAll(beans);
        return new BeansConfigPostProcessingContext(beansConfig, beanNameGenerator, problemReporter, beanDefinitionRegistry, new BeansConfigRegistrationSupport(Collections.unmodifiableCollection(beansClone), readerEventListener), problems);
    }
}

