/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.springframework.ide.eclipse.config.graph.figures.EndTag;
import org.springframework.ide.eclipse.config.graph.figures.StartTag;
import org.springframework.ide.eclipse.config.graph.figures.SubgraphFigure;

public class SequentialActivityFigure
extends SubgraphFigure {
    public SequentialActivityFigure(int direction) {
        super((IFigure)new StartTag("", direction), (IFigure)new EndTag("", direction), direction);
        if (direction == 16) {
            this.setBorder((Border)new MarginBorder(8, 0, 0, 0));
        } else {
            this.setBorder((Border)new MarginBorder(0, 8, 0, 0));
        }
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.direction == 16) {
            Dimension dim = new Dimension();
            int hHeader = this.getHeader().getPreferredSize().height;
            int hFooter = this.getFooter().getPreferredSize().height;
            dim.height = hHeader >= hFooter ? hHeader : hFooter;
            dim.height += this.getInsets().getHeight();
            dim.width = 50;
            return dim;
        }
        return super.getPreferredSize(wHint, hHint);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setBackgroundColor(ColorConstants.button);
        Rectangle r = this.getBounds();
        if (this.direction == 16) {
            graphics.fillRectangle(r.x + 10, r.y + 18, r.width - 24, 8);
        } else {
            graphics.fillRectangle(r.x + 18, r.y + 10, 8, r.height - 18);
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        if (this.direction == 16) {
            this.getClientArea(rect);
            Dimension size = this.footer.getPreferredSize();
            this.footer.setLocation(rect.getTopRight().translate(-size.width, 0));
            this.footer.setSize(size);
        }
    }
}

