/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.widgets;

import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.meta.ConfigPropertyType;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetAbstractBase;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetBoolean;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetFile;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetHidden;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetInteger;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetMultiCheck;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetRegex;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetSingleSelect;
import net.sf.eclipsecs.ui.config.widgets.ConfigPropertyWidgetString;
import net.sf.eclipsecs.ui.config.widgets.IConfigPropertyWidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class ConfigPropertyWidgetFactory {
    private ConfigPropertyWidgetFactory() {
    }

    public static IConfigPropertyWidget createWidget(Composite parent, ConfigProperty prop, Shell shell) {
        ConfigPropertyWidgetAbstractBase widget = null;
        ConfigPropertyType type = prop.getMetaData().getDatatype();
        if (prop.isPropertyReference()) {
            widget = new ConfigPropertyWidgetString(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.String)) {
            widget = new ConfigPropertyWidgetString(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.StringArray)) {
            widget = new ConfigPropertyWidgetString(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.Integer)) {
            widget = new ConfigPropertyWidgetInteger(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.SingleSelect)) {
            widget = new ConfigPropertyWidgetSingleSelect(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.Boolean)) {
            widget = new ConfigPropertyWidgetBoolean(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.MultiCheck)) {
            widget = new ConfigPropertyWidgetMultiCheck(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.Hidden)) {
            widget = new ConfigPropertyWidgetHidden(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.File)) {
            widget = new ConfigPropertyWidgetFile(parent, prop);
        } else if (type.equals((Object)ConfigPropertyType.Regex)) {
            widget = new ConfigPropertyWidgetRegex(parent, prop);
        }
        widget.initialize();
        return widget;
    }
}

