/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.osgi.service.prefs.BackingStoreException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.ui.SpringUIMessages;
import org.springframework.ide.eclipse.ui.dialogs.ProjectAndPreferencePage;
import org.springframework.ide.eclipse.ui.dialogs.ProjectBuilderPropertyTab;
import org.springframework.ide.eclipse.ui.dialogs.ProjectValidatorPropertyTab;
import org.springsource.ide.eclipse.commons.core.SpringCorePreferences;

public class ProjectPropertyPage
extends ProjectAndPreferencePage {
    public static final String PREF_ID = "org.springframework.ide.eclipse.ui.preferencePage";
    public static final String PROP_ID = "org.springframework.ide.eclipse.ui.projectPropertyPage";
    private ProjectBuilderPropertyTab builderTab = null;
    private ProjectValidatorPropertyTab validatorTab = null;
    private Button useChangeDetectionForJavaFiles;
    private Button useNonLockingClassLoader;

    public ProjectPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    @Override
    protected Control createPreferenceContent(Composite composite) {
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        TabItem validatorItem = new TabItem(folder, 0);
        this.validatorTab = new ProjectValidatorPropertyTab(this.getShell(), (IProject)this.getElement());
        validatorItem.setControl(this.validatorTab.createContents((Composite)folder));
        validatorItem.setText(SpringUIMessages.ProjectValidatorPropertyPage_title);
        TabItem builderItem = new TabItem(folder, 0);
        this.builderTab = new ProjectBuilderPropertyTab((IProject)this.getElement());
        builderItem.setControl(this.builderTab.createContents((Composite)folder));
        builderItem.setText(SpringUIMessages.ProjectBuilderPropertyPage_title);
        if (!this.isProjectPreferencePage()) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.springframework.ide.eclipse.core");
            Label options = new Label(composite, 64);
            options.setText("Options:");
            options.setLayoutData((Object)new GridData(768));
            this.useChangeDetectionForJavaFiles = new Button(composite, 32);
            this.useChangeDetectionForJavaFiles.setText(SpringUIMessages.ProjectBuilderPropertyPage_IncrementalCompileMessage);
            this.useChangeDetectionForJavaFiles.setSelection(prefs.getBoolean("org.springframework.ide.eclipse.core.useChangeDetectionForJavaFiles", true));
            Label note = new Label(composite, 64);
            note.setText(SpringUIMessages.ProjectBuilderPropertyPage_IncrementalCompileNote);
            note.setLayoutData((Object)new GridData(768));
            this.useNonLockingClassLoader = new Button(composite, 32);
            this.useNonLockingClassLoader.setText(SpringUIMessages.ProjectBuilderPropertyPage_NonLockingClassLoaderMessage);
            this.useNonLockingClassLoader.setSelection(prefs.getBoolean("org.springframework.ide.eclipse.core.useNonLockingClassLoader", false));
            note = new Label(composite, 64);
            note.setText(SpringUIMessages.ProjectBuilderPropertyPage_NonLockingClassLoaderNote);
            note.setLayoutData((Object)new GridData(768));
        }
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    @Override
    protected String getPreferencePageID() {
        return PREF_ID;
    }

    @Override
    protected String getPropertyPageID() {
        return PROP_ID;
    }

    @Override
    protected boolean hasProjectSpecificOptions(IProject project) {
        return SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.core").getBoolean("enable.project.preferences", false);
    }

    public boolean performOk() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.springframework.ide.eclipse.core");
        if (this.isProjectPreferencePage()) {
            if (this.useProjectSettings()) {
                SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.core").putBoolean("enable.project.preferences", true);
            } else {
                SpringCorePreferences.getProjectPreferences((IProject)this.getProject(), (String)"org.springframework.ide.eclipse.core").putBoolean("enable.project.preferences", false);
            }
        } else {
            prefs.putBoolean("org.springframework.ide.eclipse.core.useChangeDetectionForJavaFiles", this.useChangeDetectionForJavaFiles.getSelection());
            prefs.putBoolean("org.springframework.ide.eclipse.core.useNonLockingClassLoader", this.useNonLockingClassLoader.getSelection());
        }
        this.builderTab.performOk();
        this.validatorTab.performOk();
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SpringCore.log((Throwable)e);
            return false;
        }
        return super.performOk();
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.validatorTab.performDefaults();
    }
}

