/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPreferences;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.IgnoreExceptionOfType;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.boot.util.ProcessListenerAdapter;
import org.springframework.ide.eclipse.boot.util.ProcessTracker;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public abstract class AbstractBootLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    private static final String SILENT_EXIT_EXCEPTION = "org.springframework.boot.devtools.restart.SilentExitExceptionHandler$SilentExitException";
    private static final String M2E_CLASSPATH_PROVIDER = "org.eclipse.m2e.launchconfig.classpathProvider";
    protected static final String M2E_SOURCEPATH_PROVIDER = "org.eclipse.m2e.launchconfig.sourcepathProvider";
    public static final String JAVA_LAUNCH_CONFIG_TYPE_ID = IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION;
    public static final String ENABLE_DEBUG_OUTPUT = "spring.boot.debug.enable";
    public static final boolean DEFAULT_ENABLE_DEBUG_OUTPUT = false;
    private static final String BOOT_MAVEN_SOURCE_PATH_PROVIDER = "org.springframework.ide.eclipse.boot.launch.BootMavenSourcePathProvider";
    private static final String PROPS_PREFIX = "spring.boot.prop.";
    private static final char OID_SEPERATOR = ':';

    public String[] getClasspath(ILaunchConfiguration conf) throws CoreException {
        try {
            ILaunchConfigurationWorkingCopy wc = AbstractBootLaunchConfigurationDelegate.copyAs(conf, JAVA_LAUNCH_CONFIG_TYPE_ID);
            AbstractBootLaunchConfigurationDelegate.enableMavenClasspathProvider(wc);
            return super.getClasspath((ILaunchConfiguration)wc);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return super.getClasspath(conf);
        }
    }

    public static List<ILaunchConfiguration> getLaunchConfigs(IProject p, String confTypeId) {
        try {
            ILaunchConfiguration[] configs;
            ILaunchManager lm = AbstractBootLaunchConfigurationDelegate.getLaunchMan();
            ILaunchConfigurationType type = lm.getLaunchConfigurationType(confTypeId);
            if (type != null && (configs = lm.getLaunchConfigurations(type)) != null && configs.length > 0) {
                ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration conf = iLaunchConfigurationArray[n2];
                    if (p.equals((Object)AbstractBootLaunchConfigurationDelegate.getProject(conf))) {
                        result.add(conf);
                    }
                    ++n2;
                }
                return result;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return Collections.emptyList();
    }

    public static void clearProperties(ILaunchConfigurationWorkingCopy conf) {
        try {
            for (Object _prefixedProp : conf.getAttributes().keySet()) {
                String prefixedProp = (String)_prefixedProp;
                if (!prefixedProp.startsWith(PROPS_PREFIX)) continue;
                conf.removeAttribute(prefixedProp);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
    }

    public static String getMainType(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
    }

    public static void setMainType(ILaunchConfigurationWorkingCopy config, String typeName) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, typeName);
    }

    public static List<PropVal> getProperties(ILaunchConfiguration conf) {
        ArrayList<PropVal> props = new ArrayList<PropVal>();
        try {
            for (Map.Entry _e : conf.getAttributes().entrySet()) {
                try {
                    Map.Entry e = _e;
                    String prefixed = (String)e.getKey();
                    if (!prefixed.startsWith(PROPS_PREFIX)) continue;
                    String name = prefixed.substring(PROPS_PREFIX.length());
                    int dotPos = name.lastIndexOf(58);
                    if (dotPos >= 0) {
                        name = name.substring(0, dotPos);
                    }
                    String valueEnablement = (String)e.getValue();
                    String value = valueEnablement.substring(1);
                    boolean enabled = valueEnablement.charAt(0) == '1';
                    props.add(new PropVal(name, value, enabled));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return props;
    }

    public static void setProperties(ILaunchConfigurationWorkingCopy conf, List<PropVal> props) {
        if (props == null) {
            props = Collections.emptyList();
        }
        AbstractBootLaunchConfigurationDelegate.clearProperties(conf);
        int oid = 0;
        for (PropVal p : props) {
            if (!StringUtil.hasText((String)p.name)) continue;
            String prefixed = PROPS_PREFIX + p.name + ':' + oid++;
            String valueEnabled = String.valueOf(p.isChecked ? (char)'1' : '0') + p.value;
            conf.setAttribute(prefixed, valueEnabled);
        }
    }

    protected void addPropertiesArguments(ArrayList<String> args, List<PropVal> props) {
        for (PropVal p : props) {
            if (!p.isChecked || p.name.isEmpty() || p.value.isEmpty()) continue;
            args.add(this.propertyAssignmentArgument(p.name, p.value));
        }
    }

    protected String propertyAssignmentArgument(String name, String value) {
        if (name.contains("=")) {
            throw new IllegalArgumentException("property name shouldn't contain '=':" + name);
        }
        return "--" + name + "=" + value;
    }

    public static boolean getEnableDebugOutput(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(ENABLE_DEBUG_OUTPUT, false);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return false;
        }
    }

    public static void setEnableDebugOutput(ILaunchConfigurationWorkingCopy conf, boolean enable) {
        conf.setAttribute(ENABLE_DEBUG_OUTPUT, enable);
    }

    public static IProject getProject(ILaunchConfiguration conf) {
        try {
            String pname = AbstractBootLaunchConfigurationDelegate.getProjectName(conf);
            if (StringUtil.hasText((String)pname)) {
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(pname);
                return p;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration conf) throws CoreException {
        return conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
    }

    public static void setProject(ILaunchConfigurationWorkingCopy conf, IProject p) {
        if (p == null) {
            conf.removeAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME);
        } else {
            conf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, p.getName());
        }
    }

    static void enableMavenClasspathProvider(ILaunchConfigurationWorkingCopy conf) {
        try {
            IProject p;
            if (conf.getType().getIdentifier().equals(JAVA_LAUNCH_CONFIG_TYPE_ID) && (p = AbstractBootLaunchConfigurationDelegate.getProject((ILaunchConfiguration)conf)) != null && p.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                if (!conf.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER)) {
                    conf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, M2E_CLASSPATH_PROVIDER);
                }
                if (!conf.hasAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER)) {
                    conf.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, M2E_SOURCEPATH_PROVIDER);
                }
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
    }

    private static ILaunchConfigurationWorkingCopy copyAs(ILaunchConfiguration conf, String newType) throws CoreException {
        ILaunchManager launchManager = AbstractBootLaunchConfigurationDelegate.getLaunchMan();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType(newType);
        ILaunchConfigurationWorkingCopy wc = launchConfigurationType.newInstance(null, launchManager.generateLaunchConfigurationName(conf.getName()));
        wc.setAttributes(conf.getAttributes());
        return wc;
    }

    public static ILaunchManager getLaunchMan() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void launch(ILaunchConfiguration conf, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        conf = this.configureSourcePathProvider(conf);
        if ("debug".equals(mode) && AbstractBootLaunchConfigurationDelegate.isIgnoreSilentExitException(conf)) {
            final IgnoreExceptionOfType breakpointListener = new IgnoreExceptionOfType(launch, SILENT_EXIT_EXCEPTION);
            new ProcessTracker((ProcessTracker.ProcessListener)new ProcessListenerAdapter(){

                public void debugTargetTerminated(ProcessTracker tracker, IDebugTarget target) {
                    if (launch.equals(target.getLaunch())) {
                        breakpointListener.dispose();
                        tracker.dispose();
                    }
                }
            });
        }
        super.launch(conf, mode, launch, monitor);
    }

    protected ILaunchConfiguration configureSourcePathProvider(ILaunchConfiguration conf) throws CoreException {
        IProject project = BootLaunchConfigurationDelegate.getProject(conf);
        if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            conf = this.setAttribute(conf, IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, BOOT_MAVEN_SOURCE_PATH_PROVIDER);
        }
        return conf;
    }

    private ILaunchConfiguration setAttribute(ILaunchConfiguration conf, String a, String v) {
        try {
            if (!Objects.equals(v, conf.getAttribute(a, null))) {
                ILaunchConfigurationWorkingCopy wc = conf.getWorkingCopy();
                wc.setAttribute(a, v);
                conf = wc.doSave();
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return conf;
    }

    public static boolean isIgnoreSilentExitException(ILaunchConfiguration conf) {
        return BootPreferences.getInstance().isIgnoreSilentExit();
    }

    public static class PropVal {
        public String name;
        public String value;
        public boolean isChecked;

        public PropVal(String name, String value, boolean isChecked) {
            Assert.isNotNull((Object)name);
            Assert.isNotNull((Object)value);
            this.name = name;
            this.value = value;
            this.isChecked = isChecked;
        }

        public String toString() {
            return String.valueOf(this.isChecked ? "[X] " : "[ ] ") + this.name + "=" + this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.isChecked ? 1231 : 1237);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropVal other = (PropVal)obj;
            if (this.isChecked != other.isChecked) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

