/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springframework.ide.eclipse.boot.launch.AbstractBootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.DeletedLaunchConfTerminator;
import org.springframework.ide.eclipse.boot.launch.livebean.JmxBeanSupport;
import org.springframework.ide.eclipse.boot.launch.process.BootProcessFactory;
import org.springframework.ide.eclipse.boot.launch.profiles.ProfileHistory;
import org.springframework.ide.eclipse.boot.launch.util.PortFinder;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springsource.ide.eclipse.commons.core.util.OsUtils;

public class BootLaunchConfigurationDelegate
extends AbstractBootLaunchConfigurationDelegate {
    private static DeletedLaunchConfTerminator deletedLaunchConfTerminator = null;
    public static final String TYPE_ID = "org.springframework.ide.eclipse.boot.launch";
    public static final String BOOT_LAUNCH_MARKER = "isBootLaunch";
    public static final String ENABLE_LIVE_BEAN_SUPPORT = "spring.boot.livebean.enable";
    public static final boolean DEFAULT_ENABLE_LIVE_BEAN_SUPPORT = true;
    private static final String JMX_PORT = "spring.boot.livebean.port";
    public static final int DEFAULT_JMX_PORT = 0;
    public static final String ANSI_CONSOLE_OUTPUT = "spring.boot.ansi.console";
    private static final String PROFILE = "spring.boot.profile";
    public static final String DEFAULT_PROFILE = "";
    public static final String ENABLE_LIFE_CYCLE = "spring.boot.lifecycle.enable";
    public static final boolean DEFAULT_ENABLE_LIFE_CYCLE = true;
    public static final String HIDE_FROM_BOOT_DASH = "spring.boot.dash.hidden";
    public static final boolean DEFAULT_HIDE_FROM_BOOT_DASH = false;
    private static final String ENABLE_CHEAP_ENTROPY_VM_ARGS = "-Djava.security.egd=file:/dev/./urandom ";
    private static final String TERMINATION_TIMEOUT = "spring.boot.lifecycle.termination.timeout";
    public static final long DEFAULT_TERMINATION_TIMEOUT = 15000L;
    private ProfileHistory profileHistory = new ProfileHistory();
    private static final ThreadLocal<ILaunch> CURRENT_LAUNCH = new ThreadLocal();

    public static synchronized void ensureDeletedLaunchConfTerminator() {
        if (deletedLaunchConfTerminator == null) {
            deletedLaunchConfTerminator = new DeletedLaunchConfTerminator(DebugPlugin.getDefault().getLaunchManager(), l -> {
                try {
                    return l != null && Boolean.valueOf(l.getAttribute(BOOT_LAUNCH_MARKER)) != false;
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return false;
                }
            });
        }
    }

    @Override
    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        BootLaunchConfigurationDelegate.ensureDeletedLaunchConfTerminator();
        launch.setAttribute(BOOT_LAUNCH_MARKER, "true");
        CURRENT_LAUNCH.set(launch);
        try {
            this.profileHistory.updateHistory(BootLaunchConfigurationDelegate.getProject(conf), BootLaunchConfigurationDelegate.getProfile(conf));
            super.launch(conf, mode, launch, monitor);
        }
        finally {
            CURRENT_LAUNCH.remove();
        }
    }

    public String getProgramArguments(ILaunchConfiguration conf) throws CoreException {
        boolean enableAnsiConsole;
        List<AbstractBootLaunchConfigurationDelegate.PropVal> props = BootLaunchConfigurationDelegate.getProperties(conf);
        String profile = BootLaunchConfigurationDelegate.getProfile(conf);
        boolean debugOutput = BootLaunchConfigurationDelegate.getEnableDebugOutput(conf);
        boolean bl = enableAnsiConsole = BootLaunchConfigurationDelegate.supportsAnsiConsoleOutput() && BootLaunchConfigurationDelegate.getEnableAnsiConsoleOutput(conf);
        if (!(props != null && !props.isEmpty() || debugOutput || StringUtil.hasText((String)profile) || enableAnsiConsole)) {
            return super.getProgramArguments(conf);
        }
        ArrayList<String> args = new ArrayList<String>();
        if (debugOutput) {
            args.add("--debug");
        }
        if (StringUtil.hasText((String)profile)) {
            args.add(this.propertyAssignmentArgument("spring.profiles.active", profile));
        }
        if (enableAnsiConsole) {
            args.add(this.propertyAssignmentArgument("spring.output.ansi.enabled", "always"));
        }
        this.addPropertiesArguments(args, props);
        args.addAll(Arrays.asList(DebugPlugin.parseArguments((String)super.getProgramArguments(conf))));
        return DebugPlugin.renderArguments((String[])args.toArray(new String[args.size()]), null);
    }

    public String getVMArguments(ILaunchConfiguration conf) throws CoreException {
        try {
            String vmArgs = super.getVMArguments(conf);
            EnumSet<JmxBeanSupport.Feature> enabled = BootLaunchConfigurationDelegate.getEnabledJmxFeatures(conf);
            if (!enabled.isEmpty()) {
                int port = 0;
                try {
                    port = Integer.parseInt(BootLaunchConfigurationDelegate.getJMXPort(conf));
                }
                catch (Exception exception) {}
                if (port == 0) {
                    port = PortFinder.findFreePort();
                }
                String enableLiveBeanArgs = JmxBeanSupport.jmxBeanVmArgs(port, enabled);
                vmArgs = String.valueOf(enableLiveBeanArgs) + vmArgs;
                CURRENT_LAUNCH.get().setAttribute(JMX_PORT, DEFAULT_PROFILE + port);
            }
            return vmArgs;
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return super.getVMArguments(conf);
        }
    }

    public static EnumSet<JmxBeanSupport.Feature> getEnabledJmxFeatures(ILaunchConfiguration conf) {
        EnumSet<JmxBeanSupport.Feature> enabled = EnumSet.noneOf(JmxBeanSupport.Feature.class);
        if (BootLaunchConfigurationDelegate.getEnableLiveBeanSupport(conf)) {
            enabled.add(JmxBeanSupport.Feature.LIVE_BEAN_GRAPH);
        }
        if (BootLaunchConfigurationDelegate.getEnableLifeCycle(conf)) {
            enabled.add(JmxBeanSupport.Feature.LIFE_CYCLE);
        }
        return enabled;
    }

    public static boolean isHiddenFromBootDash(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(HIDE_FROM_BOOT_DASH, false);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return false;
        }
    }

    public static void setHiddenFromBootDash(ILaunchConfigurationWorkingCopy conf, boolean hide) {
        conf.setAttribute(HIDE_FROM_BOOT_DASH, hide);
    }

    public static boolean getEnableLifeCycle(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(ENABLE_LIFE_CYCLE, true);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return true;
        }
    }

    public static void setEnableLifeCycle(ILaunchConfigurationWorkingCopy wc, boolean enable) {
        wc.setAttribute(ENABLE_LIFE_CYCLE, enable);
    }

    public static boolean canUseLifeCycle(ILaunchConfiguration conf) {
        return BootLaunchConfigurationDelegate.getEnableLifeCycle(conf) && BootLaunchConfigurationDelegate.supportsLifeCycleManagement(conf);
    }

    public static boolean canUseLifeCycle(ILaunch launch) {
        ILaunchConfiguration conf = launch.getLaunchConfiguration();
        return conf != null && BootLaunchConfigurationDelegate.canUseLifeCycle(conf);
    }

    public static boolean supportsLifeCycleManagement(ILaunchConfiguration conf) {
        IProject p = BootLaunchConfigurationDelegate.getProject(conf);
        if (p != null) {
            return BootPropertyTester.supportsLifeCycleManagement((IProject)p);
        }
        return false;
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy wc, IProject project, String mainType) {
        BootLaunchConfigurationDelegate.setProcessFactory(wc, BootProcessFactory.class);
        BootLaunchConfigurationDelegate.setProject(wc, project);
        if (mainType != null) {
            BootLaunchConfigurationDelegate.setMainType(wc, mainType);
        }
        BootLaunchConfigurationDelegate.setEnableLiveBeanSupport(wc, true);
        BootLaunchConfigurationDelegate.setEnableLifeCycle(wc, true);
        BootLaunchConfigurationDelegate.setTerminationTimeout(wc, "15000");
        BootLaunchConfigurationDelegate.setJMXPort(wc, "0");
        if (!OsUtils.isWindows()) {
            BootLaunchConfigurationDelegate.setVMArgs(wc, ENABLE_CHEAP_ENTROPY_VM_ARGS);
        }
    }

    public static void setTerminationTimeout(ILaunchConfigurationWorkingCopy wc, String value) {
        wc.setAttribute(TERMINATION_TIMEOUT, value);
    }

    public static String getTerminationTimeout(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(TERMINATION_TIMEOUT, "15000");
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return "15000";
        }
    }

    public static long getTerminationTimeoutAsLong(ILaunchConfiguration conf) {
        String v = BootLaunchConfigurationDelegate.getTerminationTimeout(conf);
        if (StringUtil.hasText((String)v)) {
            try {
                return Long.parseLong(v);
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }
        return 15000L;
    }

    private static void setVMArgs(ILaunchConfigurationWorkingCopy wc, String vmArgs) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
    }

    public static void setProcessFactory(ILaunchConfigurationWorkingCopy wc, Class<BootProcessFactory> klass) {
        wc.setAttribute("process_factory_id", klass.getName());
    }

    public static boolean getEnableLiveBeanSupport(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(ENABLE_LIVE_BEAN_SUPPORT, true);
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
            return true;
        }
    }

    public static String getJMXPort(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(JMX_PORT, DEFAULT_PROFILE);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return DEFAULT_PROFILE;
        }
    }

    public static void setEnableLiveBeanSupport(ILaunchConfigurationWorkingCopy conf, boolean value) {
        conf.setAttribute(ENABLE_LIVE_BEAN_SUPPORT, value);
    }

    public static void setJMXPort(ILaunchConfigurationWorkingCopy conf, String portAsStr) {
        conf.setAttribute(JMX_PORT, portAsStr);
    }

    public static String getProfile(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(PROFILE, DEFAULT_PROFILE);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return DEFAULT_PROFILE;
        }
    }

    public static void setProfile(ILaunchConfigurationWorkingCopy conf, String profile) {
        conf.setAttribute(PROFILE, profile);
    }

    public static ILaunchConfiguration duplicate(ILaunchConfiguration conf) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = BootLaunchConfigurationDelegate.createWorkingCopy(conf.getName());
        for (Map.Entry e : conf.getAttributes().entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (!(value instanceof String)) continue;
            wc.setAttribute(key, (String)value);
        }
        int existingJmxPort = BootLaunchConfigurationDelegate.getJMXPortAsInt(conf);
        if (existingJmxPort > 0) {
            BootLaunchConfigurationDelegate.setJMXPort(wc, DEFAULT_PROFILE + JmxBeanSupport.randomPort());
        }
        return wc.doSave();
    }

    public static ILaunchConfigurationWorkingCopy createWorkingCopy(String nameHint) throws CoreException {
        String name = BootLaunchConfigurationDelegate.getLaunchMan().generateLaunchConfigurationName(nameHint);
        return BootLaunchConfigurationDelegate.getConfType().newInstance(null, name);
    }

    public static ILaunchConfigurationType getConfType() {
        return BootLaunchConfigurationDelegate.getLaunchMan().getLaunchConfigurationType(TYPE_ID);
    }

    public static ILaunchConfiguration createConf(IType type) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = BootLaunchConfigurationDelegate.createWorkingCopy(type);
        return wc.doSave();
    }

    public static ILaunchConfigurationWorkingCopy createWorkingCopy(IType type) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = BootLaunchConfigurationDelegate.getConfType();
        IProject project = type.getJavaProject().getProject();
        String projectName = type.getJavaProject().getElementName();
        String shortTypeName = type.getTypeQualifiedName('.');
        String typeName = type.getFullyQualifiedName();
        wc = configType.newInstance(null, BootLaunchConfigurationDelegate.getLaunchMan().generateLaunchConfigurationName(String.valueOf(projectName) + " - " + shortTypeName));
        BootLaunchConfigurationDelegate.setDefaults(wc, project, typeName);
        wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
        return wc;
    }

    public static ILaunchConfiguration createConf(IProject project) throws CoreException {
        return BootLaunchConfigurationDelegate.createConf(JavaCore.create((IProject)project));
    }

    public static ILaunchConfiguration createConf(IJavaProject project) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = BootLaunchConfigurationDelegate.getConfType();
        String projectName = project.getElementName();
        wc = configType.newInstance(null, BootLaunchConfigurationDelegate.getLaunchMan().generateLaunchConfigurationName(projectName));
        BootLaunchConfigurationDelegate.setDefaults(wc, project.getProject(), null);
        wc.setMappedResources(new IResource[]{project.getUnderlyingResource()});
        return wc.doSave();
    }

    public static int getJMXPortAsInt(ILaunchConfiguration conf) {
        String jmxPortStr = BootLaunchConfigurationDelegate.getJMXPort(conf);
        if (jmxPortStr != null) {
            try {
                return Integer.parseInt(jmxPortStr);
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public static int getJMXPortAsInt(ILaunch launch) {
        String jmxPortStr = launch.getAttribute(JMX_PORT);
        if (jmxPortStr != null) {
            try {
                return Integer.parseInt(jmxPortStr);
            }
            catch (Exception exception) {}
        }
        return -1;
    }

    public static long getTerminationTimeoutAsLong(ILaunch launch) {
        ILaunchConfiguration conf = launch.getLaunchConfiguration();
        if (conf != null) {
            return BootLaunchConfigurationDelegate.getTerminationTimeoutAsLong(conf);
        }
        return 15000L;
    }

    public static boolean supportsAnsiConsoleOutput() {
        Bundle bundle = Platform.getBundle((String)"net.mihai-nita.ansicon.plugin");
        return bundle != null && bundle.getState() != 1;
    }

    public static boolean getEnableAnsiConsoleOutput(ILaunchConfiguration conf) {
        boolean defaultValue = BootLaunchConfigurationDelegate.supportsAnsiConsoleOutput();
        try {
            return conf.getAttribute(ANSI_CONSOLE_OUTPUT, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public static void setEnableAnsiConsoleOutput(ILaunchConfigurationWorkingCopy wc, boolean enable) {
        wc.setAttribute(ANSI_CONSOLE_OUTPUT, enable);
    }
}

