/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.CheckboxLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.IProfileHistory;
import org.springframework.ide.eclipse.boot.launch.LaunchTabSelectionModel;
import org.springframework.ide.eclipse.boot.launch.MainTypeNameLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.ProfileLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.SelectProjectLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.livebean.EnableJmxFeaturesModel;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public class BootLaunchUIModel {
    public final SelectProjectLaunchTabModel project = SelectProjectLaunchTabModel.create();
    public final MainTypeNameLaunchTabModel mainTypeName = MainTypeNameLaunchTabModel.create();
    public final ProfileLaunchTabModel profile;
    public final LaunchTabSelectionModel<Boolean> enableDebug;
    public final EnableJmxFeaturesModel enableJmx;
    public final LaunchTabSelectionModel<Boolean> hideFromDash;
    public final LaunchTabSelectionModel<Boolean> ansiConsoleOutput;

    public BootLaunchUIModel(IProfileHistory profileHistory) {
        this.profile = ProfileLaunchTabModel.create((LiveExpression<IProject>)this.project.selection, profileHistory);
        this.enableDebug = CheckboxLaunchTabModel.create("spring.boot.debug.enable", false);
        this.enableJmx = new EnableJmxFeaturesModel();
        this.hideFromDash = CheckboxLaunchTabModel.create("spring.boot.dash.hidden", false);
        this.ansiConsoleOutput = CheckboxLaunchTabModel.create("spring.boot.ansi.console", BootLaunchConfigurationDelegate.supportsAnsiConsoleOutput());
    }

    public static class MainTypeValidator
    extends Validator {
        private LiveVariable<String> mainTypeName;

        public MainTypeValidator(LiveVariable<String> n) {
            this.mainTypeName = n;
            this.dependsOn((LiveExpression)this.mainTypeName);
        }

        protected ValidationResult compute() {
            String name = (String)this.mainTypeName.getValue();
            if (!StringUtil.hasText((String)name)) {
                return ValidationResult.error((String)"No Main type selected");
            }
            return ValidationResult.OK;
        }
    }
}

