/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.LaunchTabSelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public class CheckboxLaunchTabModel
extends LaunchTabSelectionModel<Boolean> {
    private String attributeName;
    private boolean defaultValue;

    public static CheckboxLaunchTabModel create(String attributeName, boolean defaultValue) {
        LiveVariable enable = new LiveVariable();
        return new CheckboxLaunchTabModel(attributeName, defaultValue, (LiveVariable<Boolean>)enable, (LiveExpression<ValidationResult>)Validator.OK);
    }

    protected CheckboxLaunchTabModel(String attributeName, boolean defaultValue, LiveVariable<Boolean> selection, LiveExpression<ValidationResult> validator) {
        super(selection, validator);
        this.attributeName = attributeName;
        this.defaultValue = defaultValue;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration conf) {
        this.selection.setValue((Object)this.getAttribute(conf));
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        this.setAttribute(conf, (Boolean)this.selection.getValue());
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
        this.setAttribute(conf, this.defaultValue);
    }

    protected boolean getAttribute(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(this.attributeName, this.defaultValue);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return this.defaultValue;
        }
    }

    protected void setAttribute(ILaunchConfigurationWorkingCopy conf, Boolean value) {
        conf.setAttribute(this.attributeName, value.booleanValue());
    }
}

