/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.util.function.Predicate;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchManager;
import org.springframework.ide.eclipse.boot.util.Log;

public class DeletedLaunchConfTerminator
implements ILaunchConfigurationListener {
    private ILaunchManager lm;
    private final Predicate<ILaunch> isInteresting;

    public DeletedLaunchConfTerminator(ILaunchManager lm, Predicate<ILaunch> isInteresting) {
        this.isInteresting = isInteresting;
        this.lm = lm;
        this.lm.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration deletedConf) {
        System.out.println("Deleted conf: " + deletedConf);
        ILaunch[] iLaunchArray = this.lm.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration conf;
            ILaunch l = iLaunchArray[n2];
            if (l.canTerminate() && !l.isTerminated() && this.isInteresting.test(l) && ((conf = l.getLaunchConfiguration()) == null || deletedConf.equals(conf))) {
                try {
                    l.terminate();
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            ++n2;
        }
    }
}

