/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;

public class IgnoreExceptionOfType
implements IDebugEventFilter,
Disposable {
    private ILaunch launch;
    private String exceptionToIgnore;

    public IgnoreExceptionOfType(ILaunch launch, String exceptionToIgnore) {
        this.launch = launch;
        this.exceptionToIgnore = exceptionToIgnore;
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this);
    }

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        ArrayList<DebugEvent> filtered = new ArrayList<DebugEvent>(events.length);
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent e = debugEventArray[n2];
            if (this.select(e)) {
                filtered.add(e);
            }
            ++n2;
        }
        if (!filtered.isEmpty()) {
            return filtered.toArray(new DebugEvent[filtered.size()]);
        }
        return null;
    }

    private boolean select(DebugEvent e) {
        if (e.getKind() == 2 && e.getDetail() == 16) {
            IBreakpoint[] bps;
            IJavaThread source = (IJavaThread)e.getSource();
            if ((this.launch == null || this.launch.equals(source.getLaunch())) && (bps = source.getBreakpoints()) != null) {
                IBreakpoint[] iBreakpointArray = bps;
                int n = bps.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaExceptionBreakpoint ebp;
                    IBreakpoint bp = iBreakpointArray[n2];
                    if (bp instanceof IJavaExceptionBreakpoint && this.exceptionToIgnore.equals((ebp = (IJavaExceptionBreakpoint)bp).getExceptionTypeName())) {
                        this.resume(source);
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    private void resume(IJavaThread source) {
        try {
            source.resume();
        }
        catch (DebugException e) {
            BootActivator.log((Throwable)e);
        }
    }
}

