/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.ExistingBootProjectSelectionValidator;
import org.springframework.ide.eclipse.boot.launch.LaunchTabSelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;

public class SelectProjectLaunchTabModel
extends LaunchTabSelectionModel<IProject> {
    public static SelectProjectLaunchTabModel create() {
        LiveVariable project = new LiveVariable();
        ExistingBootProjectSelectionValidator validator = new ExistingBootProjectSelectionValidator((LiveExpression<IProject>)project);
        return new SelectProjectLaunchTabModel((LiveVariable<IProject>)project, (LiveExpression<ValidationResult>)validator);
    }

    public SelectProjectLaunchTabModel(LiveVariable<IProject> p, LiveExpression<ValidationResult> pv) {
        super(p, pv);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration conf) {
        this.selection.setValue((Object)BootLaunchConfigurationDelegate.getProject(conf));
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        BootLaunchConfigurationDelegate.setProject(conf, (IProject)this.selection.getValue());
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
        BootLaunchConfigurationDelegate.setProject(conf, null);
    }

    public IProject[] interestingProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> interesting = new ArrayList<IProject>(allProjects.length);
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (this.isInteresting(p)) {
                interesting.add(p);
            }
            ++n2;
        }
        return interesting.toArray(new IProject[interesting.size()]);
    }

    protected boolean isInteresting(IProject project) {
        return BootPropertyTester.isBootProject((IProject)project);
    }
}

