/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.console;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.util.BootLaunchUtils;
import org.springframework.ide.eclipse.boot.ui.BootUIImages;
import org.springframework.ide.eclipse.boot.util.ProcessListenerAdapter;
import org.springframework.ide.eclipse.boot.util.ProcessTracker;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;

public class BootConsolePageParticipant
implements IConsolePageParticipant {
    private ProcessConsole console;
    private ProcessTracker processTracker;
    private TerminateProcessAction terminateAction;

    public void activated() {
    }

    public void deactivated() {
    }

    public void dispose() {
        if (this.processTracker != null) {
            this.processTracker.dispose();
            this.processTracker = null;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void init(IPageBookViewPage page, IConsole console) {
        this.console = (ProcessConsole)console;
        if (this.isDevtoolsClient(this.console) || this.isBootApp(this.console)) {
            this.terminateAction = new TerminateProcessAction();
            try {
                this.terminateAction.setImageDescriptor(BootUIImages.descriptor((String)"icons/stop.gif"));
                this.terminateAction.setDisabledImageDescriptor(BootUIImages.descriptor((String)"icons/stop_disabled.gif"));
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
            IToolBarManager toolbar = page.getSite().getActionBars().getToolBarManager();
            IContributionItem replace = this.findReplacementItem(toolbar);
            if (replace != null) {
                toolbar.appendToGroup("launchGroup", (IAction)this.terminateAction);
                toolbar.remove(replace);
            }
            boolean enabled = this.getConsoleProcess().canTerminate();
            this.terminateAction.setEnabled(enabled);
            if (enabled) {
                this.processTracker = new ProcessTracker((ProcessTracker.ProcessListener)new ProcessListenerAdapter(){

                    public void processTerminated(ProcessTracker tracker, IProcess terminated) {
                        if (BootConsolePageParticipant.this.getConsoleProcess().equals(terminated)) {
                            BootConsolePageParticipant.this.terminateAction.setEnabled(false);
                            tracker.dispose();
                        }
                    }
                });
            }
        }
    }

    private boolean isDevtoolsClient(ProcessConsole console) {
        return BootConsolePageParticipant.isLaunchType(console, "org.springframework.ide.eclipse.boot.devtools.client.launch");
    }

    private IProcess getConsoleProcess() {
        if (this.console != null) {
            return this.console.getProcess();
        }
        return null;
    }

    private boolean isBootApp(ProcessConsole console) {
        return BootConsolePageParticipant.isLaunchType(console, "org.springframework.ide.eclipse.boot.launch");
    }

    private IContributionItem findReplacementItem(IToolBarManager toolbar) {
        SubContributionManager contributions = (SubContributionManager)toolbar;
        IContributionItem[] iContributionItemArray = contributions.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem actionItem;
            IAction replaceAction;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (replaceAction = (actionItem = (ActionContributionItem)item).getAction()).getClass().getName().equals("org.eclipse.debug.internal.ui.views.console.ConsoleTerminateAction")) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isLaunchType(ProcessConsole console, String typeId) {
        return BootConsolePageParticipant.isLaunchType(console.getProcess(), typeId);
    }

    private static boolean isLaunchType(IProcess process, String launchTypeId) {
        try {
            ILaunchConfiguration conf;
            ILaunch launch;
            if (process != null && (launch = process.getLaunch()) != null && (conf = launch.getLaunchConfiguration()) != null) {
                return launchTypeId.equals(conf.getType().getIdentifier());
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return false;
    }

    private class TerminateProcessAction
    extends Action {
        private TerminateProcessAction() {
        }

        public void run() {
            try {
                final IProcess process = BootConsolePageParticipant.this.console.getProcess();
                if (process != null && process.canTerminate()) {
                    Job job = new Job("Terminate process"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                BootLaunchUtils.terminate(process.getLaunch());
                                return Status.OK_STATUS;
                            }
                            catch (Exception e) {
                                return ExceptionUtil.status((Throwable)e);
                            }
                        }
                    };
                    job.schedule();
                }
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }
    }
}

