/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.devtools;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.AbstractBootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.util.WaitFor;
import org.springframework.ide.eclipse.boot.util.ProcessListenerAdapter;
import org.springframework.ide.eclipse.boot.util.ProcessTracker;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;

public class BootDevtoolsClientLaunchConfigurationDelegate
extends AbstractBootLaunchConfigurationDelegate {
    public static final String TYPE_ID = "org.springframework.ide.eclipse.boot.devtools.client.launch";
    private static final long DEBUG_CONNECT_TIMEOUT = 20000L;
    public static final String REMOTE_SPRING_APPLICATION = "org.springframework.boot.devtools.RemoteSpringApplication";
    public static final String REMOTE_URL = "spring.devtools.remote.url";
    public static final String REMOTE_SECRET = "spring.devtools.remote.secret";
    public static final String DEFAULT_REMOTE_SECRET = "";
    public static final String DEBUG_PORT = "spring.devtools.remote.debug.local-port";
    private final ThreadLocal<Integer> localDebugPort = new ThreadLocal();

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return REMOTE_SPRING_APPLICATION;
    }

    public String getProgramArguments(ILaunchConfiguration conf) throws CoreException {
        Integer debugPort;
        List<AbstractBootLaunchConfigurationDelegate.PropVal> props = BootDevtoolsClientLaunchConfigurationDelegate.getProperties(conf);
        ArrayList<String> args = new ArrayList<String>();
        this.addPropertiesArguments(args, props);
        String secret = this.getSecret(conf);
        if (StringUtil.hasText((String)secret)) {
            args.add(this.propertyAssignmentArgument(REMOTE_SECRET, secret));
        }
        if ((debugPort = this.localDebugPort.get()) != null) {
            args.add(this.propertyAssignmentArgument(DEBUG_PORT, DEFAULT_REMOTE_SECRET + debugPort));
        }
        args.add(BootDevtoolsClientLaunchConfigurationDelegate.getRemoteUrl(conf));
        return DebugPlugin.renderArguments((String[])args.toArray(new String[args.size()]), null);
    }

    private String getSecret(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(REMOTE_SECRET, DEFAULT_REMOTE_SECRET);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return DEFAULT_REMOTE_SECRET;
        }
    }

    @Override
    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor mon) throws CoreException {
        boolean isDebug = "debug".equals(mode);
        int work = isDebug ? 2 : 1;
        mon.beginTask("Launching Devtools Client for" + BootDevtoolsClientLaunchConfigurationDelegate.getProjectName(conf), work);
        if (isDebug) {
            this.localDebugPort.set(BootDevtoolsClientLaunchConfigurationDelegate.findFreePort());
        }
        try {
            super.launch(conf, "run", launch, (IProgressMonitor)new SubProgressMonitor(mon, 1));
            if (isDebug) {
                this.launchRemote(this.localDebugPort.get(), conf, launch, (IProgressMonitor)new SubProgressMonitor(mon, 1));
            }
        }
        finally {
            this.localDebugPort.remove();
            mon.done();
        }
    }

    public static int findFreePort() {
        try {
            Throwable throwable = null;
            Object var1_2 = null;
            try (ServerSocket socket = new ServerSocket(0);){
                socket.setReuseAddress(true);
                return socket.getLocalPort();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static String getRemoteUrl(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(REMOTE_URL, null);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return null;
        }
    }

    public static void setRemoteUrl(ILaunchConfigurationWorkingCopy conf, String value) {
        conf.setAttribute(REMOTE_URL, value);
    }

    public static void setRemoteSecret(ILaunchConfigurationWorkingCopy conf, String value) {
        conf.setAttribute(REMOTE_SECRET, value);
    }

    public static String getRemoteSecret(ILaunchConfigurationWorkingCopy conf) {
        try {
            return conf.getAttribute(REMOTE_SECRET, null);
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return null;
        }
    }

    private void launchRemote(int port, ILaunchConfiguration configuration, final ILaunch launch, IProgressMonitor _monitor) throws CoreException {
        if (port < 0) {
            return;
        }
        final IProgressMonitor monitor = _monitor == null ? new NullProgressMonitor() : _monitor;
        monitor.beginTask(NLS.bind((String)LaunchingMessages.JavaRemoteApplicationLaunchConfigurationDelegate_Attaching_to__0_____1, (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.subTask(LaunchingMessages.JavaRemoteApplicationLaunchConfigurationDelegate_Verifying_launch_attributes____1);
            String connectorId = "org.eclipse.jdt.launching.socketAttachConnector";
            final IVMConnector connector = JavaRuntime.getVMConnector((String)connectorId);
            if (connector == null) {
                this.abort(LaunchingMessages.JavaRemoteApplicationLaunchConfigurationDelegate_Connector_not_specified_2, null, 119);
            }
            final HashMap<String, String> argMap = new HashMap<String, String>();
            int connectTimeout = Platform.getPreferencesService().getInt("org.eclipse.jdt.launching", JavaRuntime.PREF_CONNECT_TIMEOUT, 20000, null);
            argMap.put("hostname", "localhost");
            argMap.put("timeout", DEFAULT_REMOTE_SECRET + connectTimeout);
            argMap.put("port", DEFAULT_REMOTE_SECRET + port);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            try {
                new WaitFor(20000L){

                    @Override
                    public void run() throws Exception {
                        connector.connect(argMap, monitor, launch);
                    }
                };
                new ProcessTracker((ProcessTracker.ProcessListener)new ProcessListenerAdapter(){

                    public void debugTargetTerminated(ProcessTracker tracker, IDebugTarget target) {
                        this.handleTermination(tracker, target.getLaunch());
                    }

                    public void processTerminated(ProcessTracker tracker, IProcess process) {
                        this.handleTermination(tracker, process.getLaunch());
                    }

                    private void handleTermination(ProcessTracker tracker, ILaunch targetLaunch) {
                        if (launch.equals(targetLaunch)) {
                            tracker.dispose();
                            BootDevtoolsClientLaunchConfigurationDelegate.this.terminateAllTargets(launch);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.terminateAllTargets(launch);
                throw ExceptionUtil.coreException((Throwable)e);
            }
            if (monitor.isCanceled()) {
                this.terminateAllTargets(launch);
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void terminateAllTargets(ILaunch launch) {
        IProcess[] processes;
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        int i = 0;
        while (i < debugTargets.length) {
            IDebugTarget target = debugTargets[i];
            if (target.canDisconnect()) {
                try {
                    target.disconnect();
                }
                catch (Exception e) {
                    BootActivator.log((Throwable)e);
                }
            }
            ++i;
        }
        IProcess[] iProcessArray = processes = launch.getProcesses();
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            if (process.canTerminate()) {
                try {
                    process.terminate();
                }
                catch (Exception e) {
                    BootActivator.log((Throwable)e);
                }
            }
            ++n2;
        }
    }
}

