/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.devtools;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.devtools.BootDevtoolsClientLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public class BootDevtoolsClientLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        try {
            IResource rsrc = this.getResource(selection);
            this.launch(rsrc, mode);
        }
        catch (Throwable e) {
            BootActivator.log((Throwable)e);
        }
    }

    public void launch(IResource rsrc, String mode) throws CoreException {
        ILaunchConfiguration conf;
        if (rsrc != null && rsrc.getType() == 4 && (conf = this.findOrCreateConfiguration((IProject)rsrc)) != null) {
            if (this.isLaunchable(conf)) {
                DebugUITools.launch((ILaunchConfiguration)conf, (String)mode);
            } else {
                StructuredSelection selection = new StructuredSelection(new Object[]{conf});
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)this.getShell(), (IStructuredSelection)selection, (String)this.getLaunchGroup(mode));
            }
        }
    }

    private boolean isLaunchable(ILaunchConfiguration conf) {
        IProject project = BootLaunchConfigurationDelegate.getProject(conf);
        String url = BootDevtoolsClientLaunchConfigurationDelegate.getRemoteUrl(conf);
        return project != null && BootPropertyTester.isBootProject((IProject)project) && BootPropertyTester.hasDevtools((IProject)project) && StringUtil.hasText((String)url);
    }

    private String getLaunchGroup(String launchMode) {
        if ("run".equals(launchMode)) {
            return "org.eclipse.debug.ui.launchGroup.run";
        }
        if ("debug".equals(launchMode)) {
            return "org.eclipse.debug.ui.launchGroup.debug";
        }
        return "org.eclipse.debug.ui.launchGroup.debug";
    }

    private ILaunchConfiguration findOrCreateConfiguration(IProject project) throws CoreException {
        List<ILaunchConfiguration> candidates = this.findConfigurations(project);
        if (candidates.isEmpty()) {
            return this.createConfiguration(project);
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        return this.chooseConfiguration(project, candidates);
    }

    private List<ILaunchConfiguration> findConfigurations(IProject project) throws CoreException {
        ILaunchManager lm = this.getLaunchManager();
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = lm.getLaunchConfigurations(this.getLaunchType());
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration c = iLaunchConfigurationArray[n2];
            if (Objects.equals(BootLaunchConfigurationDelegate.getProject(c), project)) {
                configs.add(c);
            }
            ++n2;
        }
        return configs;
    }

    private ILaunchConfiguration chooseConfiguration(IProject project, List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Several Devtools Client Configs found for " + project.getName());
        dialog.setMessage("Select an existing configuration");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    private ILaunchConfigurationType getLaunchType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.springframework.ide.eclipse.boot.devtools.client.launch");
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfiguration createConfiguration(IProject project) throws CoreException {
        ILaunchConfigurationType configType = this.getConfigurationType();
        String projectName = project.getName();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName("devtools-client[" + projectName + "]"));
        this.setDefaults(wc, project);
        wc.setMappedResources(new IResource[]{project});
        ILaunchConfiguration config = wc.doSave();
        return config;
    }

    private void setDefaults(ILaunchConfigurationWorkingCopy wc, IProject project) {
        BootLaunchConfigurationDelegate.setProject(wc, project);
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.springframework.ide.eclipse.boot.devtools.client.launch");
    }

    private IResource getResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object el = ss.getFirstElement();
            if (el instanceof IResource) {
                return (IResource)el;
            }
            if (el instanceof IAdaptable) {
                Object o = ((IAdaptable)el).getAdapter(IResource.class);
                return (IResource)o;
            }
        }
        return null;
    }

    public void launch(IEditorPart editor, String mode) {
        try {
            IEditorInput input = editor.getEditorInput();
            Object rsrc = input.getAdapter(IResource.class);
            if (rsrc != null) {
                this.launch((IResource)rsrc, mode);
            }
        }
        catch (Throwable e) {
            BootActivator.log((Throwable)e);
        }
    }
}

