/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.devtools;

import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.boot.launch.ExistingBootProjectSelectionValidator;
import org.springframework.ide.eclipse.boot.launch.SelectProjectLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.devtools.DevtoolsEnabledValidator;
import org.springframework.ide.eclipse.boot.launch.devtools.StringFieldLaunchTabModel;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.StringFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.validators.UrlValidator;

public class BootDevtoolsClientLaunchUIModel {
    public final SelectProjectLaunchTabModel project = this.createProjectSelectionModel();
    public final StringFieldLaunchTabModel remoteUrl = this.createRemoteUrlModel();
    public final StringFieldLaunchTabModel remoteSecret = this.createRemoteSecretModel();

    private StringFieldLaunchTabModel createRemoteUrlModel() {
        StringFieldModel field = new StringFieldModel("Remote Url", "");
        field.validator((LiveExpression)new UrlValidator(field).allowedSchemes(new String[]{"http", "https"}));
        return new StringFieldLaunchTabModel(field, "spring.devtools.remote.url");
    }

    private StringFieldLaunchTabModel createRemoteSecretModel() {
        StringFieldModel field = new StringFieldModel("Remote Secret", "");
        return new StringFieldLaunchTabModel(field, "spring.devtools.remote.secret");
    }

    private SelectProjectLaunchTabModel createProjectSelectionModel() {
        LiveVariable project = new LiveVariable();
        CompositeValidator validator = new CompositeValidator();
        validator.addChild((LiveExpression)new ExistingBootProjectSelectionValidator((LiveExpression<IProject>)project));
        validator.addChild((LiveExpression)new DevtoolsEnabledValidator((LiveVariable<IProject>)project));
        return new SelectProjectLaunchTabModel((LiveVariable<IProject>)project, (LiveExpression<ValidationResult>)validator);
    }
}

