/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.devtools;

import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public class DevtoolsEnabledValidator
extends Validator {
    private LiveVariable<IProject> project;

    public DevtoolsEnabledValidator(LiveVariable<IProject> project) {
        this.project = project;
        this.dependsOn((LiveExpression)project);
    }

    protected ValidationResult compute() {
        IProject p = (IProject)this.project.getValue();
        if (p != null && !BootPropertyTester.hasDevtools((IProject)p)) {
            return ValidationResult.error((String)("Project '" + p.getName() + "' does not have spring-boot-devtools on its classpath"));
        }
        return ValidationResult.OK;
    }
}

