/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.devtools;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.LaunchTabSelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.StringFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;

public class StringFieldLaunchTabModel
extends LaunchTabSelectionModel<String> {
    public final StringFieldModel field;
    public String attributeId;

    public StringFieldLaunchTabModel(StringFieldModel field, String attributeId) {
        super(field.getVariable(), (LiveExpression<ValidationResult>)field.getValidator());
        this.field = field;
        this.attributeId = attributeId;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration conf) {
        this.selection.setValue((Object)this.getAttribute(conf));
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        this.setAttribute(conf, (String)this.selection.getValue());
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
        this.setAttribute(conf, this.getDefaultValue());
    }

    private String getAttribute(ILaunchConfiguration conf) {
        try {
            return conf.getAttribute(this.attributeId, this.getDefaultValue());
        }
        catch (CoreException e) {
            BootActivator.log((Throwable)e);
            return this.getDefaultValue();
        }
    }

    private void setAttribute(ILaunchConfigurationWorkingCopy conf, String value) {
        conf.setAttribute(this.attributeId, value);
    }

    public String getDefaultValue() {
        return (String)this.field.getDefaultValue();
    }
}

