/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.livebean;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.util.ILaunchConfigurationTabModel;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.OrExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public class EnableJmxFeaturesModel
implements ILaunchConfigurationTabModel {
    private static final int MAX_PORT = 65536;
    public final String portFieldName = "JMX Port";
    public final String timeOutFieldName = "Termination timeout";
    public final LiveVariable<Boolean> liveBeanEnabled;
    public final LiveVariable<Boolean> lifeCycleEnabled;
    public final LiveExpression<Boolean> anyFeatureEnabled;
    public final LiveVariable<String> port;
    public final LiveVariable<String> terminationTimeout;
    private final Validator validator;
    private LiveVariable<Boolean> dirtyState = new LiveVariable((Object)false);

    public EnableJmxFeaturesModel() {
        this.liveBeanEnabled = new LiveVariable((Object)true);
        this.lifeCycleEnabled = new LiveVariable((Object)true);
        this.anyFeatureEnabled = new OrExpression(new LiveExpression[]{this.liveBeanEnabled, this.lifeCycleEnabled});
        this.port = new LiveVariable((Object)"");
        this.terminationTimeout = new LiveVariable((Object)"");
        this.liveBeanEnabled.addListener(this.makeDirty());
        this.lifeCycleEnabled.addListener(this.makeDirty());
        this.port.addListener(this.makeDirty());
        this.terminationTimeout.addListener(this.makeDirty());
        this.validator = new Validator(){
            {
                this.dependsOn(EnableJmxFeaturesModel.this.anyFeatureEnabled);
                this.dependsOn((LiveExpression)EnableJmxFeaturesModel.this.port);
                this.dependsOn((LiveExpression)EnableJmxFeaturesModel.this.terminationTimeout);
            }

            protected ValidationResult compute() {
                boolean isEnabled = (Boolean)EnableJmxFeaturesModel.this.anyFeatureEnabled.getValue();
                if (isEnabled) {
                    String portStr = (String)EnableJmxFeaturesModel.this.port.getValue();
                    if (!EnableJmxFeaturesModel.this.hasText(portStr)) {
                        return ValidationResult.error((String)"JMX Port must be specified");
                    }
                    try {
                        int portValue = Integer.parseInt(portStr.trim());
                        if (portValue < 0) {
                            return ValidationResult.error((String)"JMX Port should be a positive integer or 0");
                        }
                        if (portValue > 65536) {
                            return ValidationResult.error((String)"JMX Port should be smaller than 65536");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return ValidationResult.error((String)"JMX Port can't be parsed as an Integer");
                    }
                }
                if (((Boolean)EnableJmxFeaturesModel.this.lifeCycleEnabled.getValue()).booleanValue()) {
                    String timeoutStr = (String)EnableJmxFeaturesModel.this.terminationTimeout.getValue();
                    if (!EnableJmxFeaturesModel.this.hasText(timeoutStr)) {
                        return ValidationResult.error((String)"Termination timeout must be specified");
                    }
                    timeoutStr = timeoutStr.trim();
                    try {
                        long timeout = Long.parseLong(timeoutStr);
                        if (timeout <= 0L) {
                            return ValidationResult.error((String)"Termination timeout must be positive");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return ValidationResult.error((String)"Termination timeout can't be parsed as an Integer");
                    }
                }
                return ValidationResult.OK;
            }
        };
    }

    private boolean hasText(String portStr) {
        return portStr != null && !portStr.trim().equals("");
    }

    protected ValueListener makeDirty() {
        return new ValueListener(){

            public void gotValue(LiveExpression exp, Object value) {
                EnableJmxFeaturesModel.this.dirtyState.setValue((Object)true);
            }
        };
    }

    @Override
    public void initializeFrom(ILaunchConfiguration conf) {
        this.liveBeanEnabled.setValue((Object)BootLaunchConfigurationDelegate.getEnableLiveBeanSupport(conf));
        this.lifeCycleEnabled.setValue((Object)BootLaunchConfigurationDelegate.getEnableLifeCycle(conf));
        this.port.setValue((Object)BootLaunchConfigurationDelegate.getJMXPort(conf));
        this.terminationTimeout.setValue((Object)BootLaunchConfigurationDelegate.getTerminationTimeout(conf));
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        BootLaunchConfigurationDelegate.setEnableLiveBeanSupport(conf, (Boolean)this.liveBeanEnabled.getValue());
        BootLaunchConfigurationDelegate.setEnableLifeCycle(conf, (Boolean)this.lifeCycleEnabled.getValue());
        BootLaunchConfigurationDelegate.setJMXPort(conf, StringUtil.trim((String)((String)this.port.getValue())));
        BootLaunchConfigurationDelegate.setTerminationTimeout(conf, StringUtil.trim((String)((String)this.terminationTimeout.getValue())));
        this.getDirtyState().setValue((Object)false);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
        BootLaunchConfigurationDelegate.setEnableLiveBeanSupport(conf, true);
        BootLaunchConfigurationDelegate.setEnableLifeCycle(conf, true);
        BootLaunchConfigurationDelegate.setJMXPort(conf, "0");
        BootLaunchConfigurationDelegate.setTerminationTimeout(conf, "15000");
    }

    @Override
    public LiveVariable<Boolean> getDirtyState() {
        return this.dirtyState;
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }
}

