/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.livebean;

import java.util.EnumSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.boot.launch.livebean.EnableJmxFeaturesModel;
import org.springframework.ide.eclipse.boot.launch.livebean.JmxBeanSupport;
import org.springframework.ide.eclipse.boot.launch.util.DelegatingLaunchConfigurationTabSection;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.UIConstants;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class EnableJmxSection
extends DelegatingLaunchConfigurationTabSection {
    private static final boolean DEBUG = false;

    private static void debug(String string) {
    }

    public EnableJmxSection(IPageWithSections owner, EnableJmxFeaturesModel model) {
        super(owner, model, (IPageSection)new UI(owner, model));
    }

    private static void connectCheckbox(final LiveVariable<Boolean> checkedState, final Button widget) {
        final String name = widget.getText();
        checkedState.addListener((ValueListener)new ValueListener<Boolean>(){

            public void gotValue(LiveExpression<Boolean> exp, Boolean value) {
                boolean enable = value != null && value != false;
                EnableJmxSection.debug("Widget '" + name + "' <- " + enable);
                widget.setSelection(enable);
            }
        });
        widget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = widget.getSelection();
                EnableJmxSection.debug("Model '" + name + "' <- " + enable);
                checkedState.setValue((Object)enable);
            }
        });
    }

    static class UI
    extends WizardPageSection {
        private Button liveBeanCheckbox;
        private Button lifeCycleCheckbox;
        private Text portWidget;
        private EnableJmxFeaturesModel model;
        private Text terminationTimeoutWidget;

        public UI(IPageWithSections owner, EnableJmxFeaturesModel model) {
            super(owner);
            this.model = model;
        }

        public void createContents(Composite page) {
            Composite row = new Composite(page, 0);
            row.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
            this.liveBeanCheckbox = new Button(row, 32);
            this.liveBeanCheckbox.setText("Enable Live Bean support.");
            this.liveBeanCheckbox.setToolTipText(this.computeTooltipText("Enables support for Live Beans Graph View by adding vm args:\n", JmxBeanSupport.Feature.LIVE_BEAN_GRAPH));
            String portToolTip = "The port used for communicating with JMX beans (0 means STS should pick the port automatically on startup). The same port is used/shared by both 'Life Cycle Management' and the 'Live Beans Graph'";
            Label label = new Label(row, 0);
            label.setText("JMX Port:");
            this.portWidget = new Text(row, 2048);
            GridDataFactory.fillDefaults().hint(UIConstants.fieldLabelWidthHint((Control)this.portWidget, (int)7), -1).applyTo((Control)this.portWidget);
            label.setToolTipText(portToolTip);
            this.portWidget.setToolTipText(portToolTip);
            this.lifeCycleCheckbox = new Button(row, 32);
            this.lifeCycleCheckbox.setText("Enable Life Cycle Management.");
            this.lifeCycleCheckbox.setToolTipText(this.computeTooltipText("Requires Boot 1.3.0. Allows Boot Dashboard View to track 'STARTING' state of Boot Apps; allows STS to ask Boot Apps to shutdown nicely. Adds these vm args: \n", JmxBeanSupport.Feature.LIFE_CYCLE));
            label = new Label(row, 0);
            label.setText("Termination timeout (ms):");
            this.terminationTimeoutWidget = new Text(row, 2048);
            GridDataFactory.fillDefaults().hint(UIConstants.fieldLabelWidthHint((Control)this.terminationTimeoutWidget, (int)7), -1).applyTo((Control)this.terminationTimeoutWidget);
            this.terminationTimeoutWidget.setToolTipText("How long STS should wait, after asking Boot App nicely to stop, before attemptting to kill a the process more forcibly.");
            this.model.anyFeatureEnabled.addListener((ValueListener)new ValueListener<Boolean>(){

                public void gotValue(LiveExpression<Boolean> exp, Boolean enable) {
                    EnableJmxSection.debug("anyFeature : " + enable);
                    portWidget.setEnabled(enable.booleanValue());
                }
            });
            this.model.lifeCycleEnabled.addListener((ValueListener)new ValueListener<Boolean>(){

                public void gotValue(LiveExpression<Boolean> exp, Boolean value) {
                    terminationTimeoutWidget.setEnabled(value.booleanValue());
                }
            });
            EnableJmxSection.connectCheckbox((LiveVariable<Boolean>)this.model.liveBeanEnabled, this.liveBeanCheckbox);
            EnableJmxSection.connectCheckbox((LiveVariable<Boolean>)this.model.lifeCycleEnabled, this.lifeCycleCheckbox);
            UI.connextTextWidget(this.model.port, this.portWidget);
            UI.connextTextWidget(this.model.terminationTimeout, this.terminationTimeoutWidget);
        }

        private static void connextTextWidget(final LiveVariable<String> model, final Text widget) {
            model.addListener((ValueListener)new ValueListener<String>(){

                public void gotValue(LiveExpression<String> exp, String value) {
                    String oldValue = widget.getText();
                    if (!oldValue.equals(value)) {
                        widget.setText(value);
                    }
                }
            });
            widget.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    model.setValue((Object)widget.getText());
                }
            });
        }

        private String computeTooltipText(String baseMsg, JmxBeanSupport.Feature feature) {
            return String.valueOf(baseMsg) + JmxBeanSupport.jmxBeanVmArgs("${jmxPort}", EnumSet.of(feature));
        }

        public LiveExpression<ValidationResult> getValidator() {
            return this.model.getValidator();
        }
    }
}

