/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.process;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.util.SpringApplicationLifeCycleClientManager;
import org.springframework.ide.eclipse.boot.launch.util.SpringApplicationLifecycleClient;
import org.springframework.ide.eclipse.boot.util.DumpOutput;
import org.springframework.ide.eclipse.boot.util.RetryUtil;

public class BootProcessFactory
implements IProcessFactory {
    public static boolean ENABLE_OUTPUT_DUMPING = false;
    private static final boolean DEBUG = false;

    private static void debug(String string) {
    }

    public IProcess newProcess(ILaunch launch, final Process process, final String label, Map<String, String> attributes) {
        final int jmxPort = this.getJMXPort(launch);
        final long timeout = this.getNiceTerminationTimeout(launch);
        RuntimeProcess rtProcess = new RuntimeProcess(launch, process, label, attributes){
            SpringApplicationLifeCycleClientManager clientMgr;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.clientMgr = new SpringApplicationLifeCycleClientManager(n);
            }

            public void terminate() throws DebugException {
                block3: {
                    if (!this.terminateNicely()) {
                        try {
                            super.terminate();
                        }
                        catch (DebugException e) {
                            if (this.destroyForcibly()) break block3;
                            throw e;
                        }
                    }
                }
            }

            protected IStreamsProxy createStreamsProxy() {
                IStreamsProxy streams = super.createStreamsProxy();
                if (ENABLE_OUTPUT_DUMPING) {
                    streams.getOutputStreamMonitor().addListener((IStreamListener)new DumpOutput("%out: "));
                    streams.getErrorStreamMonitor().addListener((IStreamListener)new DumpOutput("%err: "));
                }
                return streams;
            }

            private boolean destroyForcibly() {
                try {
                    Method m = Process.class.getDeclaredMethod("destroyForcibly", new Class[0]);
                    m.invoke((Object)process, new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    BootActivator.log((Throwable)e);
                    return false;
                }
            }

            private boolean terminateNicely() {
                if (this.isTerminated()) {
                    return true;
                }
                if (jmxPort > 0) {
                    try {
                        BootProcessFactory.debug("Trying to terminate nicely: " + label);
                        SpringApplicationLifecycleClient client = this.clientMgr.getLifeCycleClient();
                        if (client == null) {
                            BootProcessFactory.debug("PROBLEM? Couldn't get JMX client");
                            throw new IOException("Couldn't get JMX client.");
                        }
                        BootProcessFactory.debug("Asking JMX client to 'stop'");
                        client.stop();
                        BootProcessFactory.debug("Asking JMX client to 'stop' -> SUCCESS");
                        RetryUtil.retry((long)100L, (long)timeout, (Callable)new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                BootProcessFactory.debug("process exited?");
                                process.exitValue();
                                BootProcessFactory.debug("process exited? -> YES");
                                return null;
                            }
                        });
                        BootProcessFactory.debug("SUCCESS terminate nicely: " + label);
                        return true;
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.clientMgr.disposeClient();
                    }
                }
                return false;
            }
        };
        return rtProcess;
    }

    private long getNiceTerminationTimeout(ILaunch launch) {
        return BootLaunchConfigurationDelegate.getTerminationTimeoutAsLong(launch);
    }

    private int getJMXPort(ILaunch launch) {
        return BootLaunchConfigurationDelegate.getJMXPortAsInt(launch);
    }
}

