/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.util.JobUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.workspace.ProjectDeletionListenerManager;

public class BootLaunchConfDeleter {
    private ILaunchManager launchMan;
    private ProjectDeletionListenerManager listenerManager;
    private static final ISchedulingRule RULE = JobUtil.lightRule((String)"LaunchConfDeleteRule");
    private String[] TYPE_IDS = new String[]{"org.springframework.ide.eclipse.boot.launch", "org.springframework.ide.eclipse.boot.devtools.client.launch"};

    public BootLaunchConfDeleter(IWorkspace workspace, ILaunchManager launchMan) {
        this.launchMan = launchMan;
        this.listenerManager = new ProjectDeletionListenerManager(workspace, new ProjectDeletionListenerManager.ProjectDeletionListener(){

            public void projectWasDeleted(IProject project) {
                BootLaunchConfDeleter.this.handleDelete(project);
            }
        });
    }

    private void handleDelete(IProject project) {
        final List<ILaunchConfiguration> confs = this.getDeletableLaunchConfigs(project);
        if (confs != null && !confs.isEmpty()) {
            Job deleteJob = new Job("Delete launch configs for " + project.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        for (ILaunchConfiguration c : confs) {
                            c.delete();
                        }
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return ExceptionUtil.status((Throwable)e);
                    }
                }
            };
            deleteJob.setRule(RULE);
            deleteJob.schedule();
        }
    }

    private List<ILaunchConfiguration> getDeletableLaunchConfigs(IProject project) {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        String[] stringArray = this.TYPE_IDS;
        int n = this.TYPE_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId = stringArray[n2];
            try {
                ILaunchConfigurationType type = this.launchMan.getLaunchConfigurationType(typeId);
                ILaunchConfiguration[] iLaunchConfigurationArray = this.launchMan.getLaunchConfigurations(type);
                int n3 = iLaunchConfigurationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILaunchConfiguration conf = iLaunchConfigurationArray[n4];
                    if (project.equals((Object)BootLaunchConfigurationDelegate.getProject(conf)) && this.isDeletable(conf)) {
                        configs.add(conf);
                    }
                    ++n4;
                }
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
            ++n2;
        }
        return configs;
    }

    private boolean isDeletable(ILaunchConfiguration conf) {
        return conf.exists() && conf.isLocal();
    }

    public void dispose() {
        this.listenerManager.dispose();
    }
}

