/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.util.SpringApplicationLifeCycleClientManager;
import org.springframework.ide.eclipse.boot.launch.util.SpringApplicationLifecycleClient;
import org.springsource.ide.eclipse.commons.ui.launch.LaunchUtils;

public class BootLaunchUtils {
    public static void terminate(Iterable<ILaunch> launches) {
        for (ILaunch l : launches) {
            try {
                BootLaunchUtils.terminate(l);
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }
    }

    public static void terminate(ILaunch l) throws DebugException, CoreException {
        ILaunchConfiguration conf = l.getLaunchConfiguration();
        if (conf != null && conf.getType().getIdentifier().equals("org.springframework.ide.eclipse.boot.launch") && BootLaunchConfigurationDelegate.canUseLifeCycle(conf)) {
            SpringApplicationLifeCycleClientManager clientMgr = new SpringApplicationLifeCycleClientManager(l);
            SpringApplicationLifecycleClient client = clientMgr.getLifeCycleClient();
            try {
                if (client != null) {
                    client.stop();
                    LaunchUtils.whenTerminated((ILaunch)l).get(BootLaunchConfigurationDelegate.getTerminationTimeoutAsLong(l), TimeUnit.MILLISECONDS);
                    return;
                }
            }
            catch (Exception exception) {
            }
            finally {
                clientMgr.disposeClient();
            }
        }
        l.terminate();
    }

    public static IProject getProject(ILaunch launch) {
        ILaunchConfiguration conf = launch.getLaunchConfiguration();
        if (conf != null) {
            return BootLaunchConfigurationDelegate.getProject(conf);
        }
        return null;
    }

    public static boolean isBootLaunch(ILaunch l) {
        try {
            ILaunchConfiguration conf = l.getLaunchConfiguration();
            if (conf != null) {
                String type = conf.getType().getIdentifier();
                return "org.springframework.ide.eclipse.boot.launch".equals(type);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return false;
    }

    public static boolean isDebugging(ILaunch launch) {
        return "debug".equals(launch.getLaunchMode());
    }

    public static List<ILaunch> getLaunches(ILaunchConfiguration c) {
        return BootLaunchUtils.getLaunches((Set<ILaunchConfiguration>)ImmutableSet.of((Object)c));
    }

    public static List<ILaunch> getLaunches(Set<ILaunchConfiguration> configs) {
        ILaunch[] all = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        ArrayList<ILaunch> selected = new ArrayList<ILaunch>();
        ILaunch[] iLaunchArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            ILaunchConfiguration lConf = l.getLaunchConfiguration();
            if (lConf != null && configs.contains(lConf)) {
                selected.add(l);
            }
            while (lConf instanceof ILaunchConfigurationWorkingCopy) {
                if (!configs.contains(lConf = ((ILaunchConfigurationWorkingCopy)lConf).getOriginal())) continue;
                selected.add(l);
            }
            ++n2;
        }
        return selected;
    }
}

