/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.util;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class CheckboxSection
extends WizardPageSection {
    private String label;
    private Button button;
    private SelectionModel<Boolean> model;
    private boolean grabVer = false;
    private boolean grabHor = false;

    public CheckboxSection(IPageWithSections owner, FieldModel<Boolean> model) {
        this(owner, (SelectionModel<Boolean>)new SelectionModel(model.getVariable(), model.getValidator()), model.getLabel());
    }

    public CheckboxSection(IPageWithSections owner, SelectionModel<Boolean> model, String label) {
        super(owner);
        this.model = model;
        this.label = label;
    }

    public CheckboxSection grabHor(boolean v) {
        this.grabHor = v;
        return this;
    }

    public CheckboxSection grabVer(boolean v) {
        this.grabVer = v;
        return this;
    }

    public void createContents(Composite page) {
        this.button = new Button(page, 32);
        this.button.setText(this.label);
        this.applyLayoutData(this.button);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((CheckboxSection)CheckboxSection.this).model.selection.setValue((Object)CheckboxSection.this.button.getSelection());
            }
        });
        this.model.selection.addListener((ValueListener)new ValueListener<Boolean>(){

            public void gotValue(LiveExpression<Boolean> exp, Boolean selected) {
                if (selected != null) {
                    CheckboxSection.this.button.setSelection(selected.booleanValue());
                }
            }
        });
    }

    protected void applyLayoutData(Button button) {
        GridDataFactory.fillDefaults().grab(this.grabHor, this.grabVer).applyTo((Control)button);
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.model.validator;
    }
}

