/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.boot.launch.util.ILaunchConfigurationTabSection;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.OrExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class GroupLaunchTabSection
extends WizardPageSection
implements ILaunchConfigurationTabSection {
    List<IPageSection> sections;
    private CompositeValidator validator;
    private String groupTitle;
    public final LiveVariable<Boolean> isVisible = new LiveVariable((Object)true);
    private int columns = 1;
    private LiveExpression<Boolean> dirtyState;

    public GroupLaunchTabSection(IPageWithSections owner, String title, WizardPageSection ... _sections) {
        super(owner);
        this.groupTitle = title;
        this.sections = new ArrayList<IPageSection>();
        WizardPageSection[] wizardPageSectionArray = _sections;
        int n = _sections.length;
        int n2 = 0;
        while (n2 < n) {
            WizardPageSection wizardPageSection = wizardPageSectionArray[n2];
            if (wizardPageSection != null) {
                this.sections.add((IPageSection)wizardPageSection);
            }
            ++n2;
        }
        this.validator = new CompositeValidator();
        for (IPageSection iPageSection : this.sections) {
            this.validator.addChild(iPageSection.getValidator());
        }
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    public void createContents(Composite page) {
        final Composite group = this.createComposite(page);
        for (IPageSection s : this.sections) {
            s.createContents(group);
        }
        this.isVisible.addListener((ValueListener)new ValueListener<Boolean>(){

            public void gotValue(LiveExpression<Boolean> exp, Boolean isVisible) {
                group.setVisible(isVisible.booleanValue());
                GridData layout = (GridData)group.getLayoutData();
                layout.exclude = isVisible == false;
                group.setLayoutData((Object)layout);
                Shell shell = GroupLaunchTabSection.this.owner.getShell();
                if (shell != null) {
                    shell.layout(new Control[]{group});
                }
            }
        });
    }

    private Composite createComposite(Composite page) {
        if (this.groupTitle != null) {
            Group group = new Group(page, 0);
            group.setText(this.groupTitle);
            group.setLayout((Layout)this.createLayout());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            return group;
        }
        Composite composite = new Composite(page, 0);
        composite.setLayout((Layout)this.createLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        return composite;
    }

    protected GridLayout createLayout() {
        GridLayout layout = new GridLayout(this.columns, true);
        if (this.groupTitle == null) {
            layout.marginWidth = 0;
        }
        return layout;
    }

    public void dispose() {
        for (IPageSection s : this.sections) {
            if (!(s instanceof Disposable)) continue;
            ((Disposable)s).dispose();
        }
        if (this.dirtyState != null) {
            this.dirtyState.dispose();
        }
        super.dispose();
    }

    public GroupLaunchTabSection columns(int i) {
        Assert.isLegal((i >= 1 ? 1 : 0) != 0);
        this.columns = i;
        return this;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration conf) {
        for (IPageSection s : this.sections) {
            if (!(s instanceof ILaunchConfigurationTabSection)) continue;
            ((ILaunchConfigurationTabSection)s).initializeFrom(conf);
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy conf) {
        for (IPageSection s : this.sections) {
            if (!(s instanceof ILaunchConfigurationTabSection)) continue;
            ((ILaunchConfigurationTabSection)s).performApply(conf);
        }
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy conf) {
        for (IPageSection s : this.sections) {
            if (!(s instanceof ILaunchConfigurationTabSection)) continue;
            ((ILaunchConfigurationTabSection)s).setDefaults(conf);
        }
    }

    @Override
    public LiveExpression<Boolean> getDirtyState() {
        if (this.dirtyState == null) {
            OrExpression ds = new OrExpression();
            for (IPageSection s : this.sections) {
                if (!(s instanceof ILaunchConfigurationTabSection)) continue;
                ds.addChild(((ILaunchConfigurationTabSection)s).getDirtyState());
            }
            this.dirtyState = ds;
        }
        return this.dirtyState;
    }
}

