/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.util;

import javax.inject.Provider;
import javax.management.remote.JMXConnector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunch;
import org.springframework.ide.eclipse.boot.launch.BootLaunchConfigurationDelegate;
import org.springframework.ide.eclipse.boot.launch.util.SpringApplicationLifecycleClient;

public class SpringApplicationLifeCycleClientManager {
    private Provider<Integer> jmxPort;
    private JMXConnector connector;
    private SpringApplicationLifecycleClient client;

    public SpringApplicationLifeCycleClientManager(Provider<Integer> jmxPort) {
        this.jmxPort = jmxPort;
    }

    public SpringApplicationLifeCycleClientManager(ILaunch l) {
        this((Provider<Integer>)((Provider)() -> BootLaunchConfigurationDelegate.getJMXPortAsInt(l)));
    }

    public SpringApplicationLifeCycleClientManager(int resolvedPort) {
        this(SpringApplicationLifeCycleClientManager.fixedPort(resolvedPort));
    }

    private static Provider<Integer> fixedPort(int resolvedPort) {
        Assert.isLegal((resolvedPort > 0 ? 1 : 0) != 0, (String)"JMX port must be > 0");
        return () -> resolvedPort;
    }

    public synchronized void disposeClient() {
        try {
            if (this.connector != null) {
                this.connector.close();
            }
        }
        catch (Exception exception) {}
        this.client = null;
        this.connector = null;
    }

    public SpringApplicationLifecycleClient getLifeCycleClient() {
        try {
            if (this.client == null) {
                Integer resolvedPort = (Integer)this.jmxPort.get();
                if (resolvedPort == null || resolvedPort <= 0) {
                    throw new IllegalStateException("JMX port not specified");
                }
                this.connector = SpringApplicationLifecycleClient.createLocalJmxConnector(resolvedPort);
                this.client = new SpringApplicationLifecycleClient(this.connector.getMBeanServerConnection(), "org.springframework.boot:type=Admin,name=SpringApplication");
            }
            return this.client;
        }
        catch (Exception exception) {
            this.disposeClient();
            return null;
        }
    }
}

