/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.util;

import java.io.IOException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class SpringApplicationLifecycleClient {
    static final String DEFAULT_OBJECT_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    private final MBeanServerConnection connection;
    private final ObjectName objectName;

    public SpringApplicationLifecycleClient(MBeanServerConnection connection, String jmxName) {
        this.connection = connection;
        this.objectName = this.toObjectName(jmxName);
    }

    public static JMXConnector createLocalJmxConnector(int port) throws IOException {
        String url = "service:jmx:rmi:///jndi/rmi://127.0.0.1:" + port + "/jmxrmi";
        JMXServiceURL serviceUrl = new JMXServiceURL(url);
        return JMXConnectorFactory.connect(serviceUrl, null);
    }

    public boolean isReady() throws Exception {
        try {
            return (Boolean)this.connection.getAttribute(this.objectName, "Ready");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return false;
        }
        catch (AttributeNotFoundException ex) {
            throw new IllegalStateException("Unexpected: attribute 'Ready' not available", ex);
        }
        catch (ReflectionException ex) {
            throw new Exception("Failed to retrieve Ready attribute", ex.getCause());
        }
        catch (MBeanException ex) {
            throw new Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new Exception(ex.getMessage(), ex);
        }
    }

    public int getProperty(String prop, int defaultValue) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object o = this.connection.invoke(this.objectName, "getProperty", new String[]{prop}, new String[]{String.class.getName()});
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return defaultValue;
    }

    public void stop() throws Exception {
        try {
            this.connection.invoke(this.objectName, "shutdown", null, null);
        }
        catch (ReflectionException ex) {
            throw new Exception("Shutdown failed", ex.getCause());
        }
        catch (MBeanException ex) {
            throw new Exception("Could not invoke shutdown operation", ex);
        }
    }

    private ObjectName toObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("Invalid jmx name '" + name + "'");
        }
    }
}

