/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.contentassist.webflow;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.MethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.IMethodFilter;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.w3c.dom.Node;

public abstract class WebflowActionMethodContentAssistCalculator
extends MethodContentAssistCalculator {
    public WebflowActionMethodContentAssistCalculator(IMethodFilter filter) {
        super(filter);
    }

    protected final IType calculateType(IContentAssistContext context) {
        if (BeansEditorUtils.hasAttribute((Node)context.getNode(), (String)"bean")) {
            IWebflowConfig config;
            String className = null;
            IFile file = context.getFile();
            if (file != null && file.exists() && (config = Activator.getModel().getProject(file.getProject()).getConfig(file)) != null) {
                Set beans = WebflowModelUtils.getBeans((IWebflowConfig)config);
                for (IBean bean : beans) {
                    if (!bean.getElementName().equals(BeansEditorUtils.getAttribute((Node)context.getNode(), (String)"bean"))) continue;
                    className = BeansModelUtils.getBeanClass((IBean)bean, null);
                }
                return JdtUtils.getJavaType((IProject)file.getProject(), className);
            }
        }
        return null;
    }
}

