/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.buildpath.TestNGContainerInitializer;
import org.testng.eclipse.util.ResourceUtil;

public class BuildPathSupport {
    private static IPath getBundleLocation() {
        URL local;
        Bundle bundle = TestNGPlugin.getDefault().getBundle();
        if (bundle == null) {
            return null;
        }
        try {
            local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = new File(local.getPath()).getAbsolutePath();
        return Path.fromOSString((String)fullPath);
    }

    public static IClasspathEntry getTestNGClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)TestNGContainerInitializer.TESTNG_PATH);
    }

    public static IClasspathEntry[] getTestNGLibraryEntries() {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IPath jarLocation = BuildPathSupport.getBundleLocation().append(ResourceUtil.getString("TestNG.library"));
        IPath srcLocation = BuildPathSupport.getBundleLocation().append(ResourceUtil.getString("TestNG.sources"));
        result.add(JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null));
        jarLocation = BuildPathSupport.getBundleLocation().append(ResourceUtil.getString("Jcommander.library"));
        result.add(JavaCore.newLibraryEntry((IPath)jarLocation, null, null));
        jarLocation = BuildPathSupport.getBundleLocation().append(ResourceUtil.getString("Bsh.library"));
        result.add(JavaCore.newLibraryEntry((IPath)jarLocation, null, null));
        jarLocation = BuildPathSupport.getBundleLocation().append(ResourceUtil.getString("Snakeyaml.library"));
        result.add(JavaCore.newLibraryEntry((IPath)jarLocation, null, null));
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    public static IPath getBundleFile(String relativePath) {
        return BuildPathSupport.getBundleLocation().append(relativePath);
    }

    public static boolean projectContainsClasspathEntry(IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] oldEntries;
        IClasspathEntry[] iClasspathEntryArray = oldEntries = project.getRawClasspath();
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry oldEntry = iClasspathEntryArray[n2];
            if (oldEntry.equals(entry)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

