/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.MultiSelector;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.TestNGMainTab;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.ui.util.TypeParser;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.StringUtils;
import org.testng.eclipse.util.TestSearchEngine;

public class GroupSelector
extends MultiSelector {
    private Map<String, List<String>> m_groupMap = Maps.newHashMap();

    GroupSelector(TestNGMainTab callback, Composite comp) {
        super(callback, comp, TestNGLaunchConfigurationConstants.LaunchType.GROUP, "TestNGMainTab.label.group", "CheckBoxTable.groups.title");
    }

    @Override
    protected Collection<String> getValues(ILaunchConfiguration configuration) {
        HashMap result = Maps.newHashMap();
        try {
            IJavaProject[] dependencies = new IJavaProject[]{};
            IJavaProject selectedProject = this.getCallback().getSelectedProject();
            try {
                String[] dependencyPrjNames = selectedProject.getRequiredProjectNames();
                if (dependencyPrjNames != null) {
                    dependencies = new IJavaProject[dependencyPrjNames.length];
                    int i = 0;
                    while (i < dependencyPrjNames.length) {
                        dependencies[i] = JDTUtil.getJavaProject(dependencyPrjNames[i]);
                        ++i;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            IJavaProject[] projects = new IJavaProject[1 + dependencies.length];
            projects[0] = selectedProject;
            System.arraycopy(dependencies, 0, projects, 1, dependencies.length);
            HashSet<IType> types = new HashSet<IType>();
            IJavaProject[] iJavaProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject project = iJavaProjectArray[n2];
                types.addAll(Arrays.asList(TestSearchEngine.findTestNGTests((IRunnableContext)this.getCallback().getLaunchConfigurationDialog(), (IJavaElement)project)));
                ++n2;
            }
            for (IType type : types) {
                ITestContent content = TypeParser.parseType(type);
                Collection<String> groupNames = content.getGroups();
                if (groupNames.isEmpty()) continue;
                for (String groupName : groupNames) {
                    ArrayList<String> rtypes = (ArrayList<String>)result.get(groupName);
                    if (rtypes == null) {
                        rtypes = new ArrayList<String>();
                        result.put(groupName, rtypes);
                    }
                    rtypes.add(type.getFullyQualifiedName());
                }
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            TestNGPlugin.log(e);
        }
        this.m_groupMap = result;
        return result.keySet();
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        List<String> groupNames = ConfigurationHelper.getGroups(configuration);
        this.setText(StringUtils.listToString(groupNames));
        this.m_groupMap.clear();
        List<String> groupClassNames = ConfigurationHelper.getGroupClasses(configuration);
        groupNames = ConfigurationHelper.getGroups(configuration);
        if (groupNames != null) {
            for (String groupName : groupNames) {
                this.m_groupMap.put(groupName, groupClassNames);
            }
            this.getValueMap().putAll(this.m_groupMap);
        }
    }

    @Override
    public Map<String, List<String>> onSelect(String[] selectedValues) {
        HashMap result = Maps.newHashMap();
        String[] stringArray = selectedValues;
        int n = selectedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            result.put(value, this.m_groupMap.get(value));
            ++n2;
        }
        return result;
    }
}

