/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.JDTUtil;

public class LaunchConfigurationHelper {
    public static IJavaProject getJavaProject(ILaunchConfiguration conf) throws CoreException {
        String projectName = ConfigurationHelper.getProjectName(conf);
        return JDTUtil.getJavaProject(projectName);
    }

    public static IProject getProject(ILaunchConfiguration conf) throws CoreException {
        String projectName = ConfigurationHelper.getProjectName(conf);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IResource[] findTestResources(ILaunchConfiguration conf) throws CoreException {
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.addAll(Arrays.asList(LaunchConfigurationHelper.findResources(conf, TestNGLaunchConfigurationConstants.DIRECTORY_TEST_LIST)));
        resources.addAll(Arrays.asList(LaunchConfigurationHelper.findResources(conf, TestNGLaunchConfigurationConstants.CLASS_TEST_LIST)));
        resources.addAll(Arrays.asList(LaunchConfigurationHelper.findResources(conf, TestNGLaunchConfigurationConstants.SOURCE_TEST_LIST)));
        resources.addAll(Arrays.asList(LaunchConfigurationHelper.findResources(conf, TestNGLaunchConfigurationConstants.SUITE_TEST_LIST)));
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IResource[] findResources(ILaunchConfiguration conf, String key) throws CoreException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        List containerPaths = conf.getAttribute(key, Collections.emptyList());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (String resPath : containerPaths) {
            IResource res = root.findMember(resPath);
            if (res == null) continue;
            resources.add(res);
        }
        return resources.toArray(new IResource[resources.size()]);
    }
}

