/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.testng.collections.Maps;
import org.testng.eclipse.launch.MultiSelector;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.TestNGMainTab;
import org.testng.eclipse.launch.components.CheckBoxTable;
import org.testng.eclipse.launch.components.SuiteFileCheckBoxTable;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.StringUtils;
import org.testng.eclipse.util.TestSearchEngine;

public class SuiteSelector2
extends MultiSelector {
    SuiteSelector2(TestNGMainTab callback, Composite comp) {
        super(callback, comp, TestNGLaunchConfigurationConstants.LaunchType.SUITE, "TestNGMainTab.label.suiteTest", "CheckBoxTable.suites.title");
        this.setTextEditable(true);
    }

    @Override
    protected Collection<String> getValues(ILaunchConfiguration configuration) {
        TestNGMainTab mainTab = this.getCallback();
        ArrayList result = Lists.newArrayList();
        try {
            IFile[] types;
            IFile[] iFileArray = types = TestSearchEngine.findSuites((IRunnableContext)mainTab.getLaunchConfigurationDialog(), new Object[]{mainTab.getSelectedProject()});
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                result.add(f.getProjectRelativePath().toString());
                ++n2;
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        List<String> names = ConfigurationHelper.getSuites(configuration);
        this.setText(StringUtils.listToString(names));
    }

    @Override
    protected Map<String, List<String>> onSelect(String[] selectedValues) {
        Map result = Maps.newHashMap();
        String[] stringArray = selectedValues;
        int n = selectedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result.put(s, Collections.emptyList());
            ++n2;
        }
        return result;
    }

    @Override
    protected CheckBoxTable getCheckBoxTable(Shell shell, String[] values, String titleId) {
        return new SuiteFileCheckBoxTable(this.getCallback().getShell(), values, titleId);
    }
}

