/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.testng.eclipse.launch.AnnotationSearchRequestor;
import org.testng.eclipse.util.ResourceUtil;

public class TestFinder {
    public void findTestsInContainer(IJavaElement element, Set result, IProgressMonitor pm) throws CoreException {
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof IType && this.internalIsTest((IType)element, pm)) {
            result.add(element);
            return;
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            pm.beginTask(ResourceUtil.getString("TestSearchEngine.message.searching"), 4);
            IRegion region = CoreTestSearchEngine.getRegion((IJavaElement)element);
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] allClasses = hierarchy.getAllClasses();
            HashSet<IType> candidates = new HashSet<IType>(allClasses.length);
            AnnotationSearchRequestor requestor = new AnnotationSearchRequestor(hierarchy, candidates);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])allClasses, (int)1);
            int matchRule = 8;
            SearchPattern annotationsPattern = SearchPattern.createPattern((String)"org.testng.annotations.Test", (int)8, (int)65536, (int)matchRule);
            SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            new SearchEngine().search(annotationsPattern, searchParticipants, scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 2));
            for (IType curr : candidates) {
                if (!CoreTestSearchEngine.isAccessibleClass((IType)curr) || Flags.isAbstract((int)curr.getFlags()) || !region.contains((IJavaElement)curr)) continue;
                result.add(curr);
            }
        }
        finally {
            pm.done();
        }
    }

    private boolean internalIsTest(IType type, IProgressMonitor monitor) throws JavaModelException {
        if (CoreTestSearchEngine.isAccessibleClass((IType)type)) {
            ITypeBinding binding;
            ASTParser parser = ASTParser.newParser((int)4);
            if (type.getCompilationUnit() != null) {
                parser.setSource(type.getCompilationUnit());
            } else {
                if (!TestFinder.isAvailable(type.getSourceRange())) {
                    parser.setProject(type.getJavaProject());
                    IBinding[] bindings = parser.createBindings(new IJavaElement[]{type}, monitor);
                    if (bindings.length == 1 && bindings[0] instanceof ITypeBinding) {
                        ITypeBinding binding2 = (ITypeBinding)bindings[0];
                        return this.isTest(binding2);
                    }
                    return false;
                }
                parser.setSource(type.getClassFile());
            }
            parser.setFocalPosition(0);
            parser.setResolveBindings(true);
            CompilationUnit root = (CompilationUnit)parser.createAST(monitor);
            ASTNode node = root.findDeclaringNode(type.getKey());
            if (node instanceof TypeDeclaration && (binding = ((TypeDeclaration)node).resolveBinding()) != null) {
                return this.isTest(binding);
            }
        }
        return false;
    }

    private static boolean isAvailable(ISourceRange range) {
        return range != null && range.getOffset() != -1;
    }

    private boolean isTest(ITypeBinding binding) {
        if (Modifier.isAbstract((int)binding.getModifiers())) {
            return false;
        }
        return this.annotatesAtLeastOneMethod(binding, "org.testng.annotations.Test");
    }

    public boolean annotatesAtLeastOneMethod(ITypeBinding type, String qualifiedName) {
        while (type != null) {
            IMethodBinding[] declaredMethods = type.getDeclaredMethods();
            int i = 0;
            while (i < declaredMethods.length) {
                IMethodBinding curr = declaredMethods[i];
                if (this.annotates(curr.getAnnotations(), qualifiedName)) {
                    return true;
                }
                ++i;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    private boolean annotates(IAnnotationBinding[] annotations, String qualifiedName) {
        int i = 0;
        while (i < annotations.length) {
            ITypeBinding annotationType = annotations[i].getAnnotationType();
            if (annotationType != null && annotationType.getQualifiedName().equals(qualifiedName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

