/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.osgi.framework.Version;
import org.testng.ITestNGListener;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.buildpath.BuildPathSupport;
import org.testng.eclipse.launch.ITestNGLaunchConfigurationProvider;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.ListenerContributorUtil;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.StringUtils;
import org.testng.remote.RemoteTestNG;
import org.testng.xml.LaunchSuite;

public class TestNGLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final Version mimJvmVer = new Version("1.7.0");

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Version vmVer;
        AbstractVMInstall vmi;
        String jreVer;
        IVMInstall install;
        IVMRunner runner;
        IJavaProject javaProject = this.getJavaProject(configuration);
        if (javaProject == null || !javaProject.exists()) {
            this.abort(ResourceUtil.getString("TestNGLaunchConfigurationDelegate.error.invalidproject"), null, 107);
        }
        if ((runner = (install = this.getVMInstall(configuration)).getVMRunner(mode)) == null) {
            this.abort(ResourceUtil.getFormattedString("TestNGLaunchConfigurationDelegate.error.novmrunner", new String[]{install.getName()}), null, 106);
        }
        if ((jreVer = (vmi = (AbstractVMInstall)install).getJavaVersion()) == null) {
            this.abort(ResourceUtil.getFormattedString("TestNGLaunchConfigurationDelegate.error.unknownjre", new String[]{install.getName()}), null, 1003);
        }
        if (TestNGLaunchConfigurationDelegate.compareVersion(vmVer = new Version(jreVer), mimJvmVer) < 0) {
            this.abort(ResourceUtil.getFormattedString("TestNGLaunchConfigurationDelegate.error.incompatiblevmversion", new String[]{jreVer}), null, 1002);
        }
        int port = SocketUtil.findFreePort();
        VMRunnerConfiguration runConfig = this.launchTypes(configuration, launch, javaProject, port, mode);
        this.setDefaultSourceLocator(launch, configuration);
        launch.setAttribute(TestNGLaunchConfigurationConstants.PORT, Integer.toString(port));
        launch.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
        launch.setAttribute(TestNGLaunchConfigurationConstants.TESTNG_RUN_NAME_ATTR, this.getRunNameAttr(configuration));
        StringBuilder sb = new StringBuilder();
        String[] stringArray = runConfig.getProgramArguments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            sb.append(arg).append(" ");
            ++n2;
        }
        TestNGPlugin.log("[TestNGLaunchConfigurationDelegate] " + this.debugConfig(runConfig));
        runner.run(runConfig, launch, monitor);
    }

    private static String join(String[] strings) {
        return TestNGLaunchConfigurationDelegate.join(strings, " ");
    }

    private static String join(String[] strings, String sep) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(strings[i]);
            ++i;
        }
        return sb.toString();
    }

    private String debugConfig(VMRunnerConfiguration config) {
        StringBuilder sb = new StringBuilder("Launching:");
        sb.append("\n  Classpath: " + TestNGLaunchConfigurationDelegate.join(config.getClassPath()));
        sb.append("\n  VMArgs:    " + TestNGLaunchConfigurationDelegate.join(config.getVMArguments()));
        sb.append("\n  Class:     " + config.getClassToLaunch());
        sb.append("\n  Args:      " + TestNGLaunchConfigurationDelegate.join(config.getProgramArguments()));
        sb.append("\n");
        sb.append("java " + TestNGLaunchConfigurationDelegate.join(config.getVMArguments()) + " -classpath " + TestNGLaunchConfigurationDelegate.join(config.getClassPath(), ":") + " " + config.getClassToLaunch() + " " + TestNGLaunchConfigurationDelegate.join(config.getProgramArguments()));
        return sb.toString();
    }

    private static void p(String s) {
        if (TestNGPlugin.isVerbose()) {
            System.out.println("[TestNGLaunchConfigurationDelegate] " + s);
        }
    }

    protected VMRunnerConfiguration launchTypes(ILaunchConfiguration configuration, ILaunch launch, IJavaProject jproject, int port, String mode) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        ExecutionArguments execArgs = new ExecutionArguments(ConfigurationHelper.getJvmArgs(configuration), "");
        VMRunnerConfiguration runConfig = this.createVMRunner(configuration, launch, jproject, port, mode);
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setEnvironment(this.getEnvironment(configuration));
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        String[] bootpath = this.getBootpath(configuration);
        runConfig.setBootClassPath(bootpath);
        return runConfig;
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "org.testng.remote.RemoteTestNG";
    }

    protected VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration, ILaunch launch, IJavaProject jproject, int port, String runMode) throws CoreException {
        boolean disabledReporters;
        String[] pa;
        String[] classPath = this.getClasspath(configuration);
        String progArgs = this.getProgramArguments(configuration);
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(this.getMainTypeName(configuration), classPath);
        ArrayList<String> argv = new ArrayList<String>(10);
        ExecutionArguments execArgs = new ExecutionArguments("", progArgs);
        String[] stringArray = pa = execArgs.getProgramArgumentsArray();
        int n = pa.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            argv.add(element);
            ++n2;
        }
        TestNGLaunchConfigurationConstants.Protocols protocol = ConfigurationHelper.getProtocol(configuration);
        switch (protocol) {
            case STRING: {
                TestNGLaunchConfigurationDelegate.p("Using the string protocol");
                argv.add("-port");
                break;
            }
            case OBJECT: {
                TestNGLaunchConfigurationDelegate.p("Using the object serialization protocol");
            }
            case JSON: {
                TestNGLaunchConfigurationDelegate.p("Using the json serialization protocol");
                argv.add("-serport");
            }
        }
        argv.add(Integer.toString(port));
        argv.add("-protocol");
        argv.add(protocol.toString());
        IProject project = jproject.getProject();
        PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
        argv.add("-d");
        argv.add(storage.getOutputAbsolutePath(jproject).toOSString());
        String preDefinedListeners = configuration.getAttribute(TestNGLaunchConfigurationConstants.PRE_DEFINED_LISTENERS, "");
        if (!preDefinedListeners.trim().equals("")) {
            if (!argv.contains("-listener")) {
                argv.add("-listener");
                argv.add(preDefinedListeners);
            } else {
                String listeners = (String)argv.get(argv.size() - 1);
                listeners = String.valueOf(listeners) + ";" + preDefinedListeners;
                argv.set(argv.size() - 1, listeners);
            }
        }
        List<ITestNGListener> contributors = ListenerContributorUtil.findReporterContributors();
        contributors.addAll(ListenerContributorUtil.findTestContributors());
        StringBuffer reportersContributors = new StringBuffer();
        boolean isFirst = true;
        for (ITestNGListener contributor : contributors) {
            if (isFirst) {
                reportersContributors.append(contributor.getClass().getName());
            } else {
                reportersContributors.append(";" + contributor.getClass().getName());
            }
            isFirst = false;
        }
        if (!reportersContributors.toString().trim().equals("")) {
            if (!argv.contains("-listener")) {
                argv.add("-listener");
                argv.add(reportersContributors.toString().trim());
            } else {
                String listeners = (String)argv.get(argv.size() - 1);
                listeners = String.valueOf(listeners) + ";" + reportersContributors.toString().trim();
                argv.set(argv.size() - 1, listeners);
            }
        }
        if (disabledReporters = storage.hasDisabledListeners(project.getName(), false)) {
            argv.add("-usedefaultlisteners");
            argv.add("false");
        }
        List<LaunchSuite> launchSuiteList = ConfigurationHelper.getLaunchSuites(jproject, configuration);
        ArrayList<String> suiteList = new ArrayList<String>();
        ArrayList<String> tempSuites = new ArrayList<String>();
        File suiteDir = TestNGPlugin.isDebug() ? new File(RemoteTestNG.DEBUG_SUITE_DIRECTORY) : TestNGPlugin.getPluginPreferenceStore().getTemporaryDirectory();
        for (LaunchSuite launchSuite : launchSuiteList) {
            File suiteFile = launchSuite.save(suiteDir);
            suiteList.add(suiteFile.getAbsolutePath());
            if (!launchSuite.isTemporary()) continue;
            suiteFile.deleteOnExit();
            tempSuites.add(suiteFile.getAbsolutePath());
        }
        if (suiteList != null) {
            for (String suite : suiteList) {
                argv.add(suite);
            }
            launch.setAttribute(TestNGLaunchConfigurationConstants.TEMP_SUITE_LIST, StringUtils.listToString(tempSuites));
        }
        vmConfig.setProgramArguments(argv.toArray(new String[argv.size()]));
        return vmConfig;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] cp = super.getClasspath(configuration);
        String[] allCp = new String[cp.length + 1];
        allCp[0] = BuildPathSupport.getBundleFile("lib/testng-remote.jar").toOSString();
        System.arraycopy(cp, 0, allCp, 1, cp.length);
        return allCp;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        ArrayList result = Lists.newArrayList();
        String[] base = super.getEnvironment(configuration);
        if (base != null && base.length > 0) {
            result.addAll(Arrays.asList(base));
        }
        for (ITestNGLaunchConfigurationProvider lcp : TestNGPlugin.getLaunchConfigurationProviders()) {
            List<String> environs = lcp.getEnvironment(configuration);
            if (environs == null || environs.size() <= 0) continue;
            result.addAll(environs);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    private String getRunNameAttr(ILaunchConfiguration configuration) {
        TestNGLaunchConfigurationConstants.LaunchType runType = ConfigurationHelper.getType(configuration);
        switch (runType) {
            case SUITE: {
                return "suite";
            }
            case GROUP: {
                return "groups";
            }
            case PACKAGE: {
                return "package";
            }
            case CLASS: {
                return "class " + configuration.getName();
            }
            case METHOD: {
                return "method " + configuration.getName();
            }
        }
        return "from context";
    }

    private static int compareVersion(Version v1, Version v2) throws CoreException {
        try {
            return v1.compareTo(v2);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            try {
                Method compareToMethod = Version.class.getMethod("compareTo", Object.class);
                return (Integer)compareToMethod.invoke((Object)v1, v2);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e2) {
                throw new CoreException(TestNGPlugin.createError(e2));
            }
        }
    }
}

