/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.TypeParser;

public class Filters {
    public static final ViewerFilter TEST_FILTER = new TestViewerFilter();
    public static final ViewerFilter SOURCE_DIRECTORY_FILTER = new SourceDirectoryFilter();
    public static ITypeFilter SINGLE_TEST = new ITypeFilter(){

        @Override
        public boolean accept(IType type) {
            boolean result = TypeParser.parseType(type).isTestNGClass();
            return result;
        }
    };
    public static ITypeFilter SUITE = new ITypeFilter(){

        @Override
        public boolean accept(IType type) {
            boolean result = false;
            Filters.ppp("CHECKING TESTNG.XML FOR " + type);
            return result;
        }
    };

    private Filters() {
    }

    public static final ViewerFilter createProjectContentFilter(IJavaProject ijp) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject iproject = ijp.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)iproject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        return new ProjectContentFilter(rejectedElements);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasTests(IContainer folder) {
        try {
            IResource[] children;
            IResource[] iResourceArray = children = folder.members();
            int n = children.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource res = iResourceArray[n2];
                if (res instanceof IFile) {
                    if (Filters.isTest((IFile)res)) {
                        return true;
                    }
                    if (res instanceof IFolder && Filters.hasTests((IContainer)res)) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private static boolean isTest(IFile file) {
        return "class".equals(file.getFileExtension()) || Filters.isSource(file) || "xml".equals(file.getFileExtension());
    }

    private static boolean isSource(IFile file) {
        return "java".equals(file.getFileExtension());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSources(IContainer folder) {
        try {
            IResource[] children;
            IResource[] iResourceArray = children = folder.members();
            int n = children.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource res = iResourceArray[n2];
                if (res instanceof IFile ? Filters.isSource((IFile)res) : res instanceof IFolder && Filters.hasSources((IContainer)res)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static void ppp(String s) {
        System.out.println("[Filters] " + s);
    }

    public static class GroupFilter
    implements ITypeFilter {
        private String[] m_groupNames;

        public GroupFilter(String ... groupNames) {
            this.m_groupNames = groupNames;
        }

        @Override
        public boolean accept(IType type) {
            ITestContent parsedType = TypeParser.parseType(type);
            if (!parsedType.isTestNGClass()) {
                return false;
            }
            String[] stringArray = this.m_groupNames;
            int n = this.m_groupNames.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (parsedType.getGroups().contains(group)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static interface ITypeFilter {
        public boolean accept(IType var1);
    }

    private static class ProjectContentFilter
    extends ViewerFilter {
        private List<IProject> m_rejectedEntries;

        private ProjectContentFilter(List<IProject> rejectedEntries) {
            this.m_rejectedEntries = rejectedEntries;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.m_rejectedEntries == null || this.m_rejectedEntries.size() == 0) {
                return true;
            }
            for (IProject prj : this.m_rejectedEntries) {
                if (!element.equals(prj)) continue;
                return false;
            }
            return true;
        }
    }

    private static class SourceDirectoryFilter
    extends ViewerFilter {
        private SourceDirectoryFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                return true;
            }
            if (element instanceof IFolder) {
                return Filters.hasSources((IContainer)element);
            }
            return false;
        }
    }

    private static class TestViewerFilter
    extends ViewerFilter {
        private TestViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                return true;
            }
            if (element instanceof IFolder) {
                return Filters.hasTests((IContainer)element);
            }
            return element instanceof IFile && Filters.isTest((IFile)element);
        }
    }
}

