/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.refactoring;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.testng.collections.Maps;
import org.testng.eclipse.ui.conversion.Visitor;

public class TestNGVisitor
extends Visitor {
    private Map<MethodDeclaration, Annotation> m_testMethods = Maps.newHashMap();
    private TypeDeclaration m_type;
    private Annotation m_testClassAnnotation;
    private Set<MethodDeclaration> m_publicMethods = Sets.newHashSet();
    private Set<String> m_assertMethods = Sets.newHashSet();

    public boolean visit(MethodDeclaration md) {
        if (this.hasAnnotation(md, "Test")) {
            this.m_testMethods.put(md, this.getAnnotation(md, "Test"));
        }
        if ((md.getModifiers() & 1) != 0) {
            boolean hasTestNGAnnotation = false;
            List modifiers = md.modifiers();
            for (IExtendedModifier m : modifiers) {
                String typeName;
                Annotation a;
                IAnnotationBinding ab;
                if (!m.isAnnotation() || (ab = (a = (Annotation)m).resolveAnnotationBinding()) == null || !(typeName = ab.getAnnotationType().getBinaryName()).contains("org.testng")) continue;
                hasTestNGAnnotation = true;
                break;
            }
            if (!hasTestNGAnnotation) {
                this.m_publicMethods.add(md);
            }
        }
        return super.visit(md);
    }

    public boolean visit(TypeDeclaration td) {
        this.m_type = td;
        this.m_testClassAnnotation = this.getAnnotation(td, "Test");
        return super.visit(td);
    }

    public boolean visit(MethodInvocation mi) {
        if (mi.getName().toString().startsWith("assert") && mi.resolveMethodBinding() == null) {
            this.m_assertMethods.add(mi.getName().toString());
        }
        return super.visit(mi);
    }

    public Set<String> getAsserts() {
        return this.m_assertMethods;
    }

    public Map<MethodDeclaration, Annotation> getTestMethods() {
        return this.m_testMethods;
    }

    public TypeDeclaration getType() {
        return this.m_type;
    }

    public Annotation getTestClassAnnotation() {
        return this.m_testClassAnnotation;
    }

    public Set<MethodDeclaration> getPublicMethods() {
        return this.m_publicMethods;
    }
}

