/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.FailureTrace;
import org.testng.eclipse.ui.Images;
import org.testng.eclipse.ui.OpenTestAction;
import org.testng.eclipse.ui.QuickRunAction;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.TestRunTab;
import org.testng.eclipse.ui.TestRunnerViewPart;
import org.testng.eclipse.ui.tree.BaseTreeItem;
import org.testng.eclipse.ui.tree.ClassTreeItem;
import org.testng.eclipse.ui.tree.ITreeItem;
import org.testng.eclipse.ui.tree.SuiteTreeItem;
import org.testng.eclipse.ui.tree.TestMethodParametersTreeItem;
import org.testng.eclipse.ui.tree.TestMethodTreeItem;
import org.testng.eclipse.ui.tree.TestTreeItem;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.StringUtils;

public abstract class AbstractTab
extends TestRunTab
implements IMenuListener {
    private Image m_testHierarchyIcon;
    private Image m_stackViewIcon;
    static final String TAG_RATIO = "ratio";
    private IMemento m_stateMemento;
    private FailureTrace m_failureTraceComponent;
    private Tree m_tree;
    private TreeViewer m_treeViewer;
    private TestRunnerViewPart m_testRunnerPart;
    private SashForm m_sashForm;
    private Composite m_parentComposite;
    private Clipboard fClipboard;
    private Map<String, ITreeItem> m_treeItemMap = Maps.newHashMap();
    private Set<RunInfo> m_runInfos = Sets.newHashSet();
    private String m_searchFilter = "";
    private Map<String, ITreeItem> m_suites = Maps.newHashMap();
    private Map<String, ITreeItem> m_tests = Maps.newHashMap();
    private Map<String, ITreeItem> m_classes = Maps.newHashMap();
    private ArrayListMultimap<String, ITreeItem> m_methods = ArrayListMultimap.create();

    @Override
    public String getSelectedTestId() {
        TreeItem[] treeItems = this.m_tree.getSelection();
        if (treeItems == null || treeItems.length == 0) {
            return null;
        }
        return BaseTreeItem.getTreeItem(treeItems[0]).getRunInfo().getMethodId();
    }

    @Override
    public void setSelectedTest(String testId) {
        if (testId == null) {
            return;
        }
        ITreeItem node = this.m_treeItemMap.get(testId);
        if (node != null) {
            this.m_tree.select(node.getTreeItem());
        } else {
            this.m_tree.deselectAll();
        }
    }

    @Override
    public Image getImage() {
        return this.m_testHierarchyIcon;
    }

    @Override
    public Composite createTabControl(Composite parent, TestRunnerViewPart runner) {
        this.m_testRunnerPart = runner;
        Composite result = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        result.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1536);
        result.setLayoutData((Object)gridData);
        this.m_sashForm = new SashForm(result, 256);
        this.m_sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_tree = new Tree((Composite)this.m_sashForm, 0x10000004);
        ViewForm stackTraceForm = new ViewForm((Composite)this.m_sashForm, 0);
        stackTraceForm.setLayoutData((Object)new GridData(4, 4, true, true));
        CLabel label = new CLabel((Composite)stackTraceForm, 0);
        label.setText(ResourceUtil.getString("TestRunnerViewPart.label.failure"));
        label.setImage(this.m_stackViewIcon);
        stackTraceForm.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)stackTraceForm, 0x800040);
        stackTraceForm.setTopCenter((Control)failureToolBar);
        this.m_failureTraceComponent = new FailureTrace((Composite)stackTraceForm, this.m_testRunnerPart, failureToolBar);
        stackTraceForm.setContent((Control)this.m_failureTraceComponent.getComposite());
        this.m_sashForm.setWeights(new int[]{50, 50});
        this.initImages();
        this.initMenu();
        this.addListeners();
        this.m_parentComposite = result;
        this.fClipboard = new Clipboard(parent.getDisplay());
        return result;
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu((Control)this.m_tree);
        this.m_tree.setMenu(menu);
    }

    private void addListeners() {
        this.m_tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTab.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractTab.this.activate();
            }
        });
        this.m_tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractTab.this.disposeIcons();
            }
        });
        this.m_tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AbstractTab.this.handleDoubleClick(e);
            }
        });
    }

    void disposeIcons() {
    }

    void handleDoubleClick(MouseEvent e) {
        OpenTestAction action;
        ITreeItem testInfo = this.getSelectedTreeItem();
        if (testInfo == null) {
            return;
        }
        if (testInfo instanceof TestMethodTreeItem && (action = new OpenTestAction(this.m_testRunnerPart, testInfo.getRunInfo())).isEnabled()) {
            action.run();
        }
    }

    private ITreeItem getSelectedTreeItem() {
        TreeItem[] treeItems = this.m_tree.getSelection();
        return treeItems.length == 0 ? null : BaseTreeItem.getTreeItem(treeItems[0]);
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.m_tree.getSelectionCount() > 0) {
            TreeItem treeItem = this.m_tree.getSelection()[0];
            RunInfo testInfo = BaseTreeItem.getTreeItem(treeItem).getRunInfo();
            manager.add((IAction)new CopyAction(treeItem));
            manager.add((IAction)new OpenTestAction(this.m_testRunnerPart, testInfo));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new QuickRunAction(this.m_testRunnerPart.getLaunchedProject(), this.m_testRunnerPart.getLastLaunch(), testInfo, "run"));
            manager.add((IAction)new QuickRunAction(this.m_testRunnerPart.getLaunchedProject(), this.m_testRunnerPart.getLastLaunch(), testInfo, "debug"));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new ExpandAllAction());
        }
    }

    @Override
    public void updateTestResult(RunInfo runInfo, boolean expand) {
        this.m_runInfos.add(runInfo);
        if (this.acceptTestResult(runInfo) && this.matchesSearchFilter(runInfo)) {
            String pathToClass;
            ITreeItem cls;
            String pathToTest;
            ITreeItem test;
            ITreeItem suite = this.m_suites.get(runInfo.getSuiteName());
            if (suite == null) {
                suite = new SuiteTreeItem(this.m_tree, runInfo);
                this.m_suites.put(runInfo.getSuiteName(), suite);
            }
            if ((test = this.m_tests.get(pathToTest = String.valueOf(runInfo.getSuiteName()) + "#" + runInfo.getTestName())) == null) {
                test = new TestTreeItem(suite.getTreeItem(), runInfo);
                this.m_tests.put(pathToTest, test);
            }
            if ((cls = this.m_classes.get(pathToClass = String.valueOf(pathToTest) + "#" + runInfo.getInstanceName())) == null) {
                cls = new ClassTreeItem(test.getTreeItem(), runInfo);
                this.m_classes.put(pathToClass, cls);
            }
            String pathToMethod = String.valueOf(pathToClass) + "#" + runInfo.getMethodName();
            TestMethodTreeItem method = new TestMethodTreeItem(cls.getTreeItem(), runInfo);
            this.m_methods.put((Object)pathToMethod, (Object)method);
            TestMethodParametersTreeItem methodParam = null;
            if (!StringUtils.isEmptyString(runInfo.getParametersDisplay())) {
                methodParam = new TestMethodParametersTreeItem(method.getTreeItem(), runInfo);
                methodParam.addToCumulatedTime(runInfo);
            }
            if (expand) {
                suite.getTreeItem().setExpanded(true);
                test.getTreeItem().setExpanded(true);
                cls.getTreeItem().setExpanded(true);
                method.getTreeItem().setExpanded(true);
                if (methodParam != null) {
                    methodParam.getTreeItem().setExpanded(true);
                    this.focus(methodParam.getTreeItem());
                } else {
                    this.focus(method.getTreeItem());
                }
            }
            suite.addToCumulatedTime(runInfo);
            test.addToCumulatedTime(runInfo);
            cls.addToCumulatedTime(runInfo);
            method.addToCumulatedTime(runInfo);
        }
    }

    private void focus(TreeItem treeItem) {
        treeItem.getParent().setSelection(treeItem);
    }

    @Override
    public void updateTestResult(List<RunInfo> results) {
        if (results.size() > 0) {
            this.reset();
            for (RunInfo ri : results) {
                this.updateTestResult(ri, false);
            }
        }
        this.postExpandAll();
    }

    private void reset() {
        this.m_suites.clear();
        this.m_tests.clear();
        this.m_classes.clear();
        this.m_methods.clear();
        this.m_tree.removeAll();
    }

    @Override
    public void updateSearchFilter(String text) {
        if (text.equals(this.m_searchFilter)) {
            return;
        }
        this.m_searchFilter = text;
        this.reset();
        this.m_treeItemMap.clear();
        for (RunInfo runInfo : this.m_runInfos) {
            if (!this.matchesSearchFilter(runInfo)) continue;
            this.updateTestResult(runInfo, true);
        }
    }

    private boolean matchesSearchFilter(RunInfo runInfo) {
        if ("".equals(this.m_searchFilter)) {
            return true;
        }
        return Pattern.matches(".*" + this.m_searchFilter.toLowerCase() + ".*", runInfo.getMethodDisplay().toLowerCase());
    }

    protected boolean acceptTestResult(RunInfo runInfo) {
        return true;
    }

    @Override
    public void aboutToStart() {
        this.reset();
        this.m_runInfos.clear();
        this.m_tree.removeAll();
        this.m_treeItemMap = new Hashtable<String, ITreeItem>();
        this.m_failureTraceComponent.clear();
    }

    @Override
    public void activate() {
        this.testSelected();
    }

    @Override
    public void setFocus() {
        this.m_tree.setFocus();
    }

    private void expandAll() {
        this.m_tree.setRedraw(false);
        TreeItem[] treeItemArray = this.m_tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.expandAll(treeItem);
            ++n2;
        }
        this.m_tree.setRedraw(true);
    }

    private void expandAll(TreeItem item) {
        item.setExpanded(true);
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            this.expandAll(subItem);
            ++n2;
        }
    }

    private RunInfo getSelectedRunInfo() {
        TreeItem[] treeItems = this.m_tree.getSelection();
        if (treeItems.length == 0) {
            return null;
        }
        return BaseTreeItem.getTreeItem(treeItems[0]).getRunInfo();
    }

    private void testSelected() {
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                AbstractTab.this.m_failureTraceComponent.showFailure(AbstractTab.this.getSelectedRunInfo());
            }
        });
    }

    private void postSyncRunnable(Runnable r) {
        this.m_tree.getDisplay().syncExec(r);
    }

    private void registerTreeItem(String id, ITreeItem treeItem) {
        this.m_treeItemMap.put(id, treeItem);
    }

    protected void onPostUpdate(TreeItem ti, int state) {
    }

    private void postExpandAll() {
        Runnable expandRunnable = new Runnable(){

            @Override
            public void run() {
                AbstractTab.this.m_tree.selectAll();
                AbstractTab.this.expandAll();
            }
        };
        this.m_tree.getDisplay().syncExec(expandRunnable);
    }

    private void initImages() {
        this.m_testHierarchyIcon = Images.getImage("testHierarchy");
        this.m_stackViewIcon = TestNGPlugin.getImageDescriptor("eview16/stackframe.gif").createImage();
    }

    private String getRatioTag() {
        return String.valueOf(this.getNameKey()) + "." + TAG_RATIO;
    }

    @Override
    public void saveState(IMemento memento) {
        if (this.m_sashForm == null) {
            if (this.m_stateMemento != null) {
                memento.putMemento(this.m_stateMemento);
            }
            return;
        }
        int[] weigths = this.m_sashForm.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(this.getRatioTag(), ratio);
    }

    @Override
    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        Integer ratio = memento.getInteger(this.getRatioTag());
        if (ratio != null) {
            this.m_sashForm.setWeights(new int[]{ratio, 1000 - ratio});
        }
    }

    @Override
    public void setOrientation(boolean horizontal) {
        this.m_sashForm.setOrientation(horizontal ? 256 : 512);
    }

    private class CopyAction
    extends Action {
        private TreeItem treeItem;

        public CopyAction(TreeItem treeItem) {
            this.treeItem = treeItem;
            this.setText(ResourceUtil.getString("CopyAction.text"));
        }

        public void run() {
            AbstractTab.this.fClipboard.setContents((Object[])new String[]{this.treeItem.getText()}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(ResourceUtil.getString("ExpandAllAction.text"));
            this.setToolTipText(ResourceUtil.getString("ExpandAllAction.tooltip"));
        }

        public void run() {
            AbstractTab.this.expandAll();
        }
    }
}

