/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.testng.eclipse.TestNGPlugin;

public class CounterPanel
extends Composite {
    private static final String TOTAL_MESSAGE_FORMAT = "{0}/{1}  ";
    private final Image m_successIcon = TestNGPlugin.getImageDescriptor("ovr16/success.gif").createImage();
    private final Image m_failureIcon = TestNGPlugin.getImageDescriptor("ovr16/failure.gif").createImage();
    private final Image m_skipIcon = TestNGPlugin.getImageDescriptor("ovr16/skip.gif").createImage();
    protected Text m_passedText;
    protected CLabel m_passedLabel;
    protected Text m_skippedText;
    protected CLabel m_skippedLabel;
    protected Text m_failedText;
    protected CLabel m_failedLabel;
    protected int m_suiteTotalCount;
    protected int m_suiteCount = 0;
    protected int m_testTotalCount;
    protected int m_testCount = 0;
    protected int m_methodTotalCount;
    protected int m_methodCount = 0;

    public CounterPanel(Composite parent) {
        super(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo((Composite)this);
        this.createReportUpperRow();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        this.m_successIcon.dispose();
        this.m_failureIcon.dispose();
        this.m_skipIcon.dispose();
    }

    private void createReportUpperRow() {
        Composite upperRow = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        upperRow.setLayoutData((Object)new GridData(768));
        upperRow.setLayout((Layout)gridLayout);
        Color backgroundColor = this.getDisplay().getSystemColor(22);
        this.m_passedLabel = this.createLabel(upperRow, "Passed: 0", this.m_successIcon, "  0  ", backgroundColor);
        this.m_failedLabel = this.createLabel(upperRow, "Failed: 0", this.m_failureIcon, "  0  ", backgroundColor);
        this.m_skippedLabel = this.createLabel(upperRow, "Skipped: 0", this.m_skipIcon, "  0  ", backgroundColor);
    }

    private Text createReportFor(Composite parent, String labelText, Color backColor, String initialText) {
        Composite cell = new Composite(parent, 2048);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = false;
        gl.horizontalSpacing = 1;
        cell.setLayout((Layout)gl);
        cell.setLayoutData((Object)new GridData(768));
        Label label = new Label(cell, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(64));
        label.setFont(JFaceResources.getBannerFont());
        Text text = new Text(cell, 8);
        text.setText(initialText);
        text.setBackground(backColor);
        text.setLayoutData((Object)new GridData(544));
        return text;
    }

    private CLabel createLabel(Composite parent, String name, Image image, String init, Color backColor) {
        CLabel label = new CLabel(parent, 0);
        if (image != null) {
            label.setImage(image);
        }
        label.setText(name);
        label.setLayoutData((Object)new GridData(800));
        label.setFont(JFaceResources.getDialogFont());
        return label;
    }

    public void reset() {
        CounterPanel.ppp("reset()");
        this.m_suiteTotalCount = 0;
        this.m_suiteCount = 0;
        this.setSuiteTotalCount(0);
        this.m_testTotalCount = 0;
        this.m_testCount = 0;
        this.setTestTotalCount(0);
        this.m_methodTotalCount = 0;
        this.m_methodCount = 0;
        this.setMethodTotalCount(0);
        this.setPassedCount(0);
        this.setFailedCount(0);
        this.setSkippedCount(0);
        this.redraw();
    }

    public void setSuiteTotalCount(int no) {
    }

    public void setSuiteCount(int no) {
    }

    public void setTestTotalCount(int no) {
    }

    public void setTestCount(int no) {
    }

    public void setMethodTotalCount(int no) {
    }

    public void setMethodCount(int no) {
    }

    public void setPassedCount(int no) {
        this.m_passedLabel.setText("Passed: " + no);
        this.m_passedLabel.redraw();
    }

    public void setFailedCount(int no) {
        this.m_failedLabel.setText("Failed: " + no);
        this.m_failedLabel.redraw();
    }

    public void setSkippedCount(int no) {
        this.m_skippedLabel.setText("Skipped: " + no);
        this.m_skippedLabel.redraw();
    }

    private static void ppp(Object msg) {
    }
}

