/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.testng.eclipse.TestNGPlugin;
import org.testng.remote.strprotocol.AbstractRemoteTestRunnerClient;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IMessageSender;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.StringMessageSender;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public class EclipseTestRunnerClient
extends AbstractRemoteTestRunnerClient {
    private StringMessageSender m_marshaller;

    public synchronized void stopTest() {
        if (this.m_marshaller != null) {
            this.m_marshaller.shutDown();
            this.m_marshaller = null;
        }
        super.stopTest();
    }

    public synchronized void startListening(IRemoteSuiteListener suiteListener, IRemoteTestListener testListener, IMessageSender messageMarshaller) {
        AbstractRemoteTestRunnerClient.ServerConnection srvConnection = new AbstractRemoteTestRunnerClient.ServerConnection(this, messageMarshaller){

            protected void handleThrowable(Throwable cause) {
                TestNGPlugin.log(cause);
            }
        };
        this.startListening(new IRemoteSuiteListener[]{suiteListener}, new IRemoteTestListener[]{testListener}, srvConnection);
    }

    protected void notifyStart(final GenericMessage genericMessage) {
        IRemoteSuiteListener[] iRemoteSuiteListenerArray = this.m_suiteListeners;
        int n = this.m_suiteListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final IRemoteSuiteListener listener = iRemoteSuiteListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.onInitialization(genericMessage);
                }
            });
            ++n2;
        }
    }

    protected void notifySuiteEvents(final SuiteMessage suiteMessage) {
        IRemoteSuiteListener[] iRemoteSuiteListenerArray = this.m_suiteListeners;
        int n = this.m_suiteListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final IRemoteSuiteListener listener = iRemoteSuiteListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    if (suiteMessage.isMessageOnStart()) {
                        listener.onStart(suiteMessage);
                    } else {
                        listener.onFinish(suiteMessage);
                    }
                }
            });
            ++n2;
        }
    }

    protected void notifyTestEvents(final TestMessage testMessage) {
        IRemoteTestListener[] iRemoteTestListenerArray = this.m_testListeners;
        int n = this.m_testListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final IRemoteTestListener listener = iRemoteTestListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    if (testMessage.isMessageOnStart()) {
                        listener.onStart(testMessage);
                    } else {
                        listener.onFinish(testMessage);
                    }
                }
            });
            ++n2;
        }
    }

    protected void notifyResultEvents(final TestResultMessage testResultMessage) {
        IRemoteTestListener[] iRemoteTestListenerArray = this.m_testListeners;
        int n = this.m_testListeners.length;
        int n2 = 0;
        while (n2 < n) {
            final IRemoteTestListener listener = iRemoteTestListenerArray[n2];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    switch (testResultMessage.getResult()) {
                        case 1016: {
                            listener.onTestStart(testResultMessage);
                            break;
                        }
                        case 1001: {
                            listener.onTestSuccess(testResultMessage);
                            break;
                        }
                        case 1002: {
                            listener.onTestFailure(testResultMessage);
                            break;
                        }
                        case 1003: {
                            listener.onTestSkipped(testResultMessage);
                            break;
                        }
                        case 1004: {
                            listener.onTestFailedButWithinSuccessPercentage(testResultMessage);
                        }
                    }
                }
            });
            ++n2;
        }
    }

    static abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        ListenerSafeRunnable() {
        }

        public void handleException(Throwable exception) {
            TestNGPlugin.log(exception);
        }
    }
}

