/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ProgressBar
extends Canvas {
    private static final int DEFAULT_WIDTH = 160;
    private static final int DEFAULT_HEIGHT = 16;
    private int m_currentTickCount = 0;
    private int m_maxTickCount = 0;
    private int m_colorBarWidth = 0;
    private Color m_oKColor;
    private Color m_failureColor;
    private Color m_stoppedColor;
    private Color m_skippedColor;
    private Color m_messageColor;
    private int m_error;
    private boolean m_stopped = false;
    private int m_totalTestsCounter;
    private int m_testCounter;
    private int m_totalMethodsCounter;
    private int m_methodsCounter;
    private String m_currentMessage = "Tests: 0/0  Methods: 0/0";
    private String m_timeMessage = "";

    public ProgressBar(Composite parent) {
        super(parent, 0);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ProgressBar.this.m_colorBarWidth = ProgressBar.this.scale(ProgressBar.this.m_currentTickCount);
                ProgressBar.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ProgressBar.this.paint(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProgressBar.this.m_failureColor.dispose();
                ProgressBar.this.m_oKColor.dispose();
                ProgressBar.this.m_stoppedColor.dispose();
            }
        });
        Display display = parent.getDisplay();
        this.m_failureColor = new Color((Device)display, 159, 63, 63);
        this.m_oKColor = new Color((Device)display, 95, 191, 95);
        this.m_skippedColor = new Color((Device)display, 255, 193, 37);
        this.m_stoppedColor = new Color((Device)display, 120, 120, 120);
        this.m_messageColor = display.getSystemColor(2);
    }

    public void setMaximum(int max, int totalMethods) {
        this.m_maxTickCount = max;
        this.m_colorBarWidth = this.scale(this.m_currentTickCount);
        this.m_totalMethodsCounter = totalMethods;
        this.paintStep(1, this.m_colorBarWidth);
    }

    public void reset(int testcounter) {
        this.m_error = 2;
        this.m_stopped = false;
        this.m_currentTickCount = 0;
        this.m_colorBarWidth = 0;
        this.m_maxTickCount = 0;
        this.m_totalTestsCounter = testcounter;
        this.m_testCounter = 0;
        this.m_totalMethodsCounter = 0;
        this.m_methodsCounter = 0;
        this.m_timeMessage = "";
        this.m_currentMessage = this.getCurrentMessage();
        this.redraw();
    }

    private String getCurrentMessage() {
        StringBuilder buf = new StringBuilder();
        buf.append("Tests: ").append(this.m_testCounter).append('/').append(this.m_totalTestsCounter).append("  Methods: ").append(this.m_methodsCounter).append(this.m_timeMessage);
        return buf.toString();
    }

    private void paintStep(int startX, int endX) {
        String string;
        GC gc = new GC((Drawable)this);
        this.setStatusColor(gc);
        Rectangle rect = this.getClientArea();
        startX = Math.max(1, startX);
        gc.fillRectangle(startX, 1, endX - startX, rect.height - 2);
        this.m_currentMessage = string = this.getCurrentMessage();
        gc.setFont(JFaceResources.getDefaultFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int stringWidth = fontMetrics.getAverageCharWidth() * string.length();
        int stringHeight = fontMetrics.getHeight();
        gc.setForeground(this.m_messageColor);
        gc.drawString(string, (rect.width - stringWidth) / 2, (rect.height - stringHeight) / 2, true);
        gc.dispose();
    }

    private void setStatusColor(GC gc) {
        if (this.m_stopped) {
            gc.setBackground(this.m_stoppedColor);
        } else if (this.m_error == 2 || this.m_error == 4) {
            gc.setBackground(this.m_failureColor);
        } else if (this.m_error == 3) {
            gc.setBackground(this.m_skippedColor);
        } else {
            gc.setBackground(this.m_oKColor);
        }
    }

    public void stopped() {
        this.m_stopped = true;
        this.redraw();
    }

    private int scale(int value) {
        if (this.m_maxTickCount > 0) {
            Rectangle r = this.getClientArea();
            if (r.width != 0) {
                return Math.max(0, value * (r.width - 2) / this.m_maxTickCount);
            }
        }
        return value;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Display disp = this.getDisplay();
        Rectangle rect = this.getClientArea();
        gc.fillRectangle(rect);
        this.drawBevelRect(gc, rect.x, rect.y, rect.width - 1, rect.height - 1, disp.getSystemColor(18), disp.getSystemColor(20));
        this.setStatusColor(gc);
        this.m_colorBarWidth = Math.min(rect.width - 2, this.m_colorBarWidth);
        gc.fillRectangle(1, 1, this.m_colorBarWidth, rect.height - 2);
        gc.setFont(JFaceResources.getDefaultFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        String msg = this.getCurrentMessage();
        int stringWidth = fontMetrics.getAverageCharWidth() * msg.length();
        int stringHeight = fontMetrics.getHeight();
        gc.setForeground(this.m_messageColor);
        gc.drawString(msg, (rect.width - stringWidth) / 2, (rect.height - stringHeight) / 2, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = new Point(160, 16);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    public void step(boolean isSuccess) {
        ++this.m_currentTickCount;
        ++this.m_methodsCounter;
        this.m_colorBarWidth = this.scale(this.m_currentTickCount);
        if (this.m_error == 1 && !isSuccess) {
            this.m_error = 2;
        }
        if (this.m_currentTickCount == this.m_maxTickCount) {
            this.m_colorBarWidth = this.getClientArea().width - 1;
        }
    }

    public void stepTests() {
        ++this.m_testCounter;
        this.m_currentMessage = this.getCurrentMessage();
        this.redraw();
    }

    public void refresh(int status, String msg) {
        this.m_error = status;
        this.m_timeMessage = msg;
        this.redraw();
    }
}

