/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.LaunchUtil;
import org.testng.eclipse.util.ResourceUtil;

public class QuickRunAction
extends Action {
    private IJavaProject m_javaProject;
    private ILaunch m_previousRun;
    private RunInfo m_runInfo;
    private String m_runMode;

    public QuickRunAction(IJavaProject javaProject, ILaunch prevLaunch, RunInfo runInfo, String mode) {
        this.m_javaProject = javaProject;
        this.m_previousRun = prevLaunch;
        this.m_runInfo = runInfo;
        this.m_runMode = mode;
        this.initUI();
    }

    private void initUI() {
        if ("run".equals(this.m_runMode)) {
            this.setText(ResourceUtil.getString("QuickRunAction.run.action.label"));
            this.setToolTipText(ResourceUtil.getString("QuickRunAction.run.action.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("dlcl16/relaunch.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunch.gif"));
        } else {
            this.setText(ResourceUtil.getString("QuickRunAction.debug.action.label"));
            this.setToolTipText(ResourceUtil.getString("QuickRunAction.debug.action.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("dlcl16/debug.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/debug.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/debug.gif"));
        }
    }

    public void run() {
        IType itype = null;
        IMethod imethod = null;
        try {
            itype = this.m_javaProject.findType(this.m_runInfo.getClassName());
            imethod = (IMethod)JDTUtil.findElement(this.m_javaProject, this.m_runInfo);
        }
        catch (JavaModelException jmex) {
            TestNGPlugin.log((IStatus)new Status(4, "org.testng.eclipse", 3333, "Cannot find method " + this.m_runInfo.getMethodDisplay() + " in class " + this.m_runInfo.getClassName(), (Throwable)jmex));
        }
        if (imethod == null || this.m_previousRun == null) {
            return;
        }
        ILaunchConfiguration config = this.m_previousRun.getLaunchConfiguration();
        try {
            this.m_runInfo.setJvmArgs(ConfigurationHelper.getJvmArgs(config));
            this.m_runInfo.setEnvironmentVariables(config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null));
        }
        catch (CoreException e) {
            TestNGPlugin.log(e);
        }
        LaunchUtil.launchMethodConfiguration(this.m_javaProject, itype, imethod, this.m_runMode, this.m_runInfo);
    }
}

