/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.ImagesUtil;
import org.testng.eclipse.ui.SuiteRunInfo;
import org.testng.eclipse.ui.TestRunnerViewPart;

public class RunHistoryAction
extends Action
implements IMenuCreator {
    private TestRunnerViewPart testRunnerViewPart;
    private Menu fMenu;
    private LinkedList<SuiteRunInfo> runs = new LinkedList();
    private SuiteRunInfo currentlyDisplayedRun;

    public RunHistoryAction(TestRunnerViewPart testRunnerViewPart) {
        this.testRunnerViewPart = testRunnerViewPart;
        this.setToolTipText("Test Run History...");
        this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/history_list.gif"));
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        for (final SuiteRunInfo run : this.runs) {
            Action filterAction = new Action(this.getText(run)){

                public void run() {
                    RunHistoryAction.this.currentlyDisplayedRun = run;
                    RunHistoryAction.this.testRunnerViewPart.reset(run);
                }
            };
            this.addActionToMenu(this.fMenu, filterAction, ImagesUtil.getImage(run.getStatus()));
        }
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new Action("Clear History"){

            public void run() {
                RunHistoryAction.this.runs.clear();
                RunHistoryAction.this.currentlyDisplayedRun = null;
                RunHistoryAction.this.testRunnerViewPart.reset();
            }
        }, null);
        return this.fMenu;
    }

    private String getText(SuiteRunInfo run) {
        String prefix = "";
        if (this.currentlyDisplayedRun == run) {
            prefix = "\u26ab ";
        }
        Date date = new Date(run.getStartTime());
        String dateStr = DateFormat.getDateTimeInstance().format(date);
        ILaunch launch = run.getLaunch();
        if (launch != null) {
            return String.valueOf(prefix) + launch.getLaunchConfiguration().getName() + " (" + dateStr + ")";
        }
        return String.valueOf(prefix) + "(" + dateStr + ")";
    }

    protected void addActionToMenu(Menu parent, Action action, Image image) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
        MenuItem menuItem = (MenuItem)item.getWidget();
        if (image != null) {
            menuItem.setImage(image);
        }
    }

    public void add(SuiteRunInfo run) {
        this.runs.addFirst(run);
        if (this.runs.size() > 20) {
            this.runs.removeLast();
        }
        this.currentlyDisplayedRun = run;
    }
}

