/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.testng.eclipse.ui.RunInfo;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public class SuiteRunInfo
implements IRemoteSuiteListener,
IRemoteTestListener {
    private IRemoteSuiteListener suiteDelegateListener;
    private IRemoteTestListener testDelegateListener;
    private int m_suitesTotalCount;
    private int m_testsTotalCount;
    private int m_methodTotalCount;
    private int m_suiteCount;
    private int m_testCount;
    private int m_methodCount;
    private int m_passedCount;
    private int m_failedCount;
    private int m_skippedCount;
    private int m_successPercentageFailed;
    private long m_startTime;
    private long m_stopTime;
    private List<RunInfo> m_results = Lists.newArrayList();
    private ILaunch launch;

    public SuiteRunInfo(IRemoteSuiteListener suiteDelegateListener, IRemoteTestListener testDelegateListener, ILaunch launch) {
        this.suiteDelegateListener = suiteDelegateListener;
        this.testDelegateListener = testDelegateListener;
        this.launch = launch;
    }

    public void removeDelegateListeners() {
        this.suiteDelegateListener = null;
        this.testDelegateListener = null;
    }

    public SuiteRunInfo(int suiteCount, int testCount) {
        this.m_suitesTotalCount = suiteCount;
        this.m_testsTotalCount = testCount;
    }

    boolean hasErrors() {
        return this.m_failedCount > 0 || this.m_successPercentageFailed > 0;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    int getStatus() {
        if (this.hasErrors()) {
            return 2;
        }
        if (this.m_skippedCount > 0) {
            return 3;
        }
        return 1;
    }

    public void onInitialization(GenericMessage genericMessage) {
        this.m_suiteCount = genericMessage.getSuiteCount();
        this.m_testCount = genericMessage.getTestCount();
        this.m_startTime = System.currentTimeMillis();
        if (this.suiteDelegateListener != null) {
            this.suiteDelegateListener.onInitialization(genericMessage);
        }
    }

    public void onStart(SuiteMessage suiteMessage) {
        if (this.suiteDelegateListener != null) {
            this.suiteDelegateListener.onStart(suiteMessage);
        }
    }

    public void onFinish(SuiteMessage suiteMessage) {
        ++this.m_suiteCount;
        if (this.isSuiteRunFinished()) {
            this.m_stopTime = System.currentTimeMillis();
        }
        if (this.suiteDelegateListener != null) {
            this.suiteDelegateListener.onFinish(suiteMessage);
        }
    }

    public void onStart(TestMessage tm) {
        this.m_methodTotalCount += tm.getTestMethodCount();
        if (this.testDelegateListener != null) {
            this.testDelegateListener.onStart(tm);
        }
    }

    public void onFinish(TestMessage tm) {
        if (this.m_methodCount != this.m_methodTotalCount) {
            this.m_methodTotalCount = this.m_methodCount;
        }
        if (this.testDelegateListener != null) {
            this.testDelegateListener.onFinish(tm);
        }
    }

    public void onTestStart(TestResultMessage trm) {
        if (this.testDelegateListener != null) {
            this.testDelegateListener.onTestStart(trm);
        }
    }

    public void onTestSuccess(TestResultMessage trm) {
        ++this.m_passedCount;
        ++this.m_methodCount;
        if (this.testDelegateListener != null) {
            this.testDelegateListener.onTestSuccess(trm);
        }
    }

    public void onTestFailure(TestResultMessage trm) {
        ++this.m_failedCount;
        ++this.m_methodCount;
        if (this.testDelegateListener != null) {
            this.testDelegateListener.onTestFailure(trm);
        }
    }

    public void onTestSkipped(TestResultMessage trm) {
        ++this.m_skippedCount;
        ++this.m_methodCount;
        if (this.testDelegateListener != null) {
            this.testDelegateListener.onTestSkipped(trm);
        }
    }

    public void onTestFailedButWithinSuccessPercentage(TestResultMessage trm) {
        ++this.m_successPercentageFailed;
        ++this.m_methodCount;
        if (this.testDelegateListener != null) {
            this.testDelegateListener.onTestFailedButWithinSuccessPercentage(trm);
        }
    }

    public boolean isSuiteRunFinished() {
        return this.m_suitesTotalCount < this.m_suiteCount;
    }

    public boolean hasRun() {
        return this.m_startTime != 0L && this.m_stopTime != 0L;
    }

    public long getRunDuration() {
        return this.m_stopTime - this.m_startTime;
    }

    public int getNewMax() {
        return (this.m_methodTotalCount * this.m_testsTotalCount + 1) / (this.m_testCount + 1);
    }

    public int getMethodCount() {
        return this.m_methodCount;
    }

    public int getPassedCount() {
        return this.m_passedCount;
    }

    public int getFailedCount() {
        return this.m_failedCount;
    }

    public int getSkippedCount() {
        return this.m_skippedCount;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public int getMethodTotalCount() {
        return this.m_methodTotalCount;
    }

    public List<RunInfo> getResults() {
        return Collections.unmodifiableList(this.m_results);
    }

    public int getNbResults() {
        return this.getResults().size();
    }

    public void add(RunInfo runInfo) {
        this.m_results.add(runInfo);
    }

    public void setSuitesTotalCount(int suitesTotalCount) {
        this.m_suitesTotalCount = suitesTotalCount;
    }

    public void setTestsTotalCount(int testsTotalCount) {
        this.m_testsTotalCount = testsTotalCount;
    }
}

