/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.ClearResultsAction;
import org.testng.eclipse.ui.CounterPanel;
import org.testng.eclipse.ui.EclipseTestRunnerClient;
import org.testng.eclipse.ui.FailureTab;
import org.testng.eclipse.ui.Images;
import org.testng.eclipse.ui.OpenTestAction;
import org.testng.eclipse.ui.ProgressBar;
import org.testng.eclipse.ui.RunHistoryAction;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.ShowNextFailureAction;
import org.testng.eclipse.ui.ShowPreviousFailureAction;
import org.testng.eclipse.ui.SuccessTab;
import org.testng.eclipse.ui.SuiteRunInfo;
import org.testng.eclipse.ui.TestRunTab;
import org.testng.eclipse.ui.WatchResultThread;
import org.testng.eclipse.ui.summary.SummaryTab;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.LaunchUtil;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.StringUtils;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IMessageSender;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.JsonMessageSender;
import org.testng.remote.strprotocol.SerializedMessageSender;
import org.testng.remote.strprotocol.StringMessageSender;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestRunnerViewPart
extends ViewPart
implements IPropertyChangeListener,
IRemoteSuiteListener,
IRemoteTestListener {
    private static final String RERUN_LAST_COMMAND = "org.testng.eclipse.shortcut.rerunLast";
    private static final String RERUN_FAILED_COMMAND = "org.testng.eclipse.shortcut.rerunFailed";
    private static final Object FAMILY_RUN = new Object();
    private IMemento m_stateMemento;
    private IJavaProject m_workingProject;
    private ILaunch m_launch;
    private Composite m_parentComposite;
    private CTabFolder m_tabFolder;
    private TestRunTab m_activeRunTab;
    private static final int VIEW_ORIENTATION_VERTICAL = 0;
    private static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    private static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    private int fOrientation = 2;
    private int fCurrentOrientation;
    private Composite progressAndSearchComposite;
    private CounterPanel m_counterPanel;
    private Composite m_progressComposite;
    private final Image m_viewIcon = TestNGPlugin.getImageDescriptor("main16/testng_noshadow.gif").createImage();
    private Action fNextAction;
    private Action fPrevAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private Action m_rerunAction;
    private IHandlerActivation m_rerunActivation;
    private Action m_rerunFailedAction;
    private IHandlerActivation m_rerunFailedActivation;
    private RunHistoryAction m_runHistoryAction;
    private Action m_openReportAction;
    private ProgressBar fProgressBar;
    private ToolItem m_stopButton;
    private Color fOKColor;
    private Color fFailureColor;
    private boolean m_isDisposed = false;
    private UpdateUIJob m_updateUIJob;
    private IsRunningJob m_isRunningJob;
    private ILock m_runLock;
    public static final String NAME = "org.testng.eclipse.ResultView";
    public static final String ID_EXTENSION_POINT_TESTRUN_TABS = "org.testng.eclipse.internal_testRunTabs";
    private static final int REFRESH_INTERVAL = 200;
    private static final String TAG_PAGE = "page";
    private static final String TAG_ORIENTATION = "orientation";
    private static final int MAX_RESULTS_THRESHOLD = 1000;
    private static final int MAX_TEXT_SIZE_THRESHOLD = 3;
    private SuiteRunInfo currentSuiteRunInfo;
    private EclipseTestRunnerClient fTestRunnerClient;
    private Set<String> testDescriptions;
    private Text m_searchText;
    private WatchResultThread m_watchThread;
    private Action m_clearTreeAction;
    private static TestRunTab m_failureTab = new FailureTab();
    private static SummaryTab m_summaryTab = new SummaryTab();
    private static final TestRunTab[] LISTENING_TABS = new TestRunTab[]{m_summaryTab};
    private static final TestRunTab[] REPORTING_TABS = new TestRunTab[]{new SuccessTab(), m_failureTab};
    private static final List<TestRunTab> ALL_TABS = new ArrayList<TestRunTab>(){
        {
            this.addAll(Arrays.asList(REPORTING_TABS));
            this.addAll(Arrays.asList(LISTENING_TABS));
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.m_stateMemento = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(FAMILY_RUN);
        }
    }

    private IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    private void restoreLayoutState(IMemento memento) {
        Integer page = memento.getInteger(TAG_PAGE);
        if (page != null) {
            int p = page;
            this.m_tabFolder.setSelection(p);
            this.m_activeRunTab = ALL_TABS.get(p);
        }
        for (TestRunTab trt : ALL_TABS) {
            trt.restoreState(memento);
        }
        Integer orientation = memento.getInteger(TAG_ORIENTATION);
        if (orientation != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TestRunnerViewPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.m_parentComposite.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void setOrientation(int orientation) {
        boolean horizontal = orientation == 1;
        for (TestRunTab trt : ALL_TABS) {
            trt.setOrientation(horizontal);
        }
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction fToggleOrientationAction;
            fToggleOrientationAction.setChecked(this.fOrientation == (fToggleOrientationAction = toggleOrientationActionArray[n2]).getOrientation());
            ++n2;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.progressAndSearchComposite.getLayout();
        this.setCounterColumns(layout);
        try {
            this.m_parentComposite.layout();
        }
        catch (Throwable cause) {
            cause.printStackTrace();
        }
    }

    private void stopTest() {
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        this.stopUpdateJobs();
    }

    public void selectNextFailure() {
        this.m_activeRunTab.selectNext();
    }

    public void selectPreviousFailure() {
        this.m_activeRunTab.selectPrevious();
    }

    public void showTest(RunInfo test) {
        this.m_activeRunTab.setSelectedTest(test.getId());
        new OpenTestAction(this, test.getClassName(), test.getMethodName(), false).run();
    }

    public void reset() {
        this.reset(0, 0);
        this.clearStatus();
        this.fNextAction.setEnabled(false);
        this.fPrevAction.setEnabled(false);
        this.m_rerunAction.setEnabled(false);
        this.m_rerunFailedAction.setEnabled(false);
        this.m_openReportAction.setEnabled(false);
    }

    private void stopUpdateJobs() {
        if (this.m_updateUIJob != null) {
            this.m_updateUIJob.stop();
            this.m_updateUIJob = null;
        }
        if (this.m_isRunningJob != null && this.m_runLock != null) {
            this.m_runLock.release();
            this.m_isRunningJob = null;
        }
    }

    private void stopProcess() {
        block7: {
            if (this.m_launch != null && !this.m_launch.isTerminated()) {
                try {
                    if ("win32".equals(Platform.getOS())) {
                        this.m_launch.terminate();
                        break block7;
                    }
                    IProcess[] iProcessArray = this.m_launch.getProcesses();
                    int n = iProcessArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess p = iProcessArray[n2];
                        try {
                            Method m = p.getClass().getDeclaredMethod("getSystemProcess", new Class[0]);
                            m.setAccessible(true);
                            Process proc = (Process)m.invoke((Object)p, new Object[0]);
                            Field f = proc.getClass().getDeclaredField("pid");
                            f.setAccessible(true);
                            int pid = (Integer)f.get(proc);
                            Runtime rt = Runtime.getRuntime();
                            rt.exec("kill -9 " + pid);
                        }
                        catch (Exception ex) {
                            TestNGPlugin.log(ex);
                        }
                        ++n2;
                    }
                }
                catch (DebugException e) {
                    TestNGPlugin.log(e);
                }
            }
        }
    }

    public void startTestRunListening(IJavaProject project, String subName, int port, final ILaunch launch) {
        StringMessageSender messageMarshaller;
        this.m_workingProject = project;
        this.m_launch = launch;
        this.aboutToLaunch(subName);
        this.fTestRunnerClient = new EclipseTestRunnerClient();
        switch (ConfigurationHelper.getProtocol(launch.getLaunchConfiguration())) {
            case STRING: {
                messageMarshaller = new StringMessageSender("localhost", port);
                break;
            }
            case OBJECT: {
                messageMarshaller = new SerializedMessageSender("localhost", port);
                break;
            }
            case JSON: {
                messageMarshaller = new JsonMessageSender("localhost", port);
                break;
            }
            default: {
                throw new IllegalStateException("unrecoginzed protocol: " + (Object)((Object)ConfigurationHelper.getProtocol(launch.getLaunchConfiguration())));
            }
        }
        String jobName = ResourceUtil.getString("TestRunnerViewPart.message.startTestRunListening");
        final Job testRunListeningJob = new Job(jobName, (IMessageSender)messageMarshaller, launch){
            private boolean initialized;
            private final /* synthetic */ IMessageSender val$messageMarshaller;
            private final /* synthetic */ ILaunch val$launch;
            {
                this.val$messageMarshaller = iMessageSender;
                this.val$launch = iLaunch;
                super($anonymous0);
                this.initialized = false;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this.val$messageMarshaller.initReceiver();
                    this.initialized = true;
                    TestRunnerViewPart.this.newSuiteRunInfo(this.val$launch);
                    TestRunnerViewPart.this.fTestRunnerClient.startListening(TestRunnerViewPart.this.currentSuiteRunInfo, TestRunnerViewPart.this.currentSuiteRunInfo, this.val$messageMarshaller);
                    TestRunnerViewPart.this.postSyncRunnable(new Runnable(){

                        @Override
                        public void run() {
                            TestRunnerViewPart.this.m_rerunAction.setEnabled(true);
                            TestRunnerViewPart.this.m_rerunFailedAction.setEnabled(false);
                            TestRunnerViewPart.this.m_openReportAction.setEnabled(true);
                        }
                    });
                }
                catch (SocketTimeoutException ex) {
                    TestNGPlugin.log(ex);
                    TestRunnerViewPart.this.postSyncRunnable(new Runnable(){

                        @Override
                        public void run() {
                            String suggestion = ResourceUtil.getString("TestRunnerViewPart.message.suggestion2");
                            new ErrorDialog(TestRunnerViewPart.this.m_progressComposite.getShell(), "Couldn't launch TestNG", suggestion, (IStatus)new Status(4, "org.testng.eclipse", ResourceUtil.getString("TestRunnerViewPart.message.reason")), 4).open();
                        }
                    });
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                if (!this.initialized) {
                    TestNGPlugin.log("Stop the socket server as it's still pending on accepting the client");
                    this.val$messageMarshaller.stopReceiver();
                }
            }
        };
        IDebugEventSetListener listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess process;
                    Object source;
                    DebugEvent event = debugEventArray[n2];
                    if (event.getKind() == 8 && (source = event.getSource()) instanceof IProcess && (process = (IProcess)source).getLaunch().equals(launch)) {
                        testRunListeningJob.cancel();
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                    ++n2;
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(listener);
        testRunListeningJob.schedule();
    }

    private void updateResultThread() {
        boolean enabled = this.getWatchResults();
        String path = this.getWatchResultDirectory();
        if (this.m_watchThread != null) {
            this.m_watchThread.stopWatching();
        }
        if (enabled) {
            TestNGPlugin.log("Monitoring results at " + path);
            this.newSuiteRunInfo(null);
            this.m_watchThread = new WatchResultThread(path, this.currentSuiteRunInfo, this.currentSuiteRunInfo);
        } else {
            if (!StringUtils.isEmptyString(path)) {
                TestNGPlugin.log("No longer monitoring results at " + path);
            }
            this.m_watchThread = null;
        }
    }

    private void newSuiteRunInfo(ILaunch launch) {
        if (this.currentSuiteRunInfo != null) {
            this.currentSuiteRunInfo.removeDelegateListeners();
        }
        this.currentSuiteRunInfo = new SuiteRunInfo(this, this, launch);
        this.m_runHistoryAction.add(this.currentSuiteRunInfo);
    }

    private void initProject() {
        IEditorInput input;
        IEditorPart ieditorpart;
        IWorkbenchPage iworkbenchpage;
        IWorkbenchWindow iworkbenchwindow;
        IWorkbench iworkbench = PlatformUI.getWorkbench();
        if (iworkbench != null && (iworkbenchwindow = iworkbench.getActiveWorkbenchWindow()) != null && (iworkbenchpage = iworkbenchwindow.getActivePage()) != null && (ieditorpart = iworkbenchpage.getActiveEditor()) != null && (input = ieditorpart.getEditorInput()) != null && input instanceof IFileEditorInput) {
            IFile resource = ((IFileEditorInput)input).getFile();
            IProject project = resource.getProject();
            IJavaProject javaProject = JDTUtil.getJavaProject(project.getName());
            if (javaProject != null) {
                this.m_workingProject = javaProject;
            } else {
                TestNGPlugin.log("Current project " + project.getName() + " is not a Java project");
            }
        }
    }

    private void aboutToLaunch(String message) {
        boolean showCaseName = TestNGPlugin.getDefault().getPreferenceStore().getBoolean("showCaseNameOnViewTitle");
        if (showCaseName) {
            String msg = ResourceUtil.getFormattedString("TestRunnerViewPart.message.launching", message);
            this.setPartName(msg);
            this.firePropertyChange(1);
        }
    }

    public synchronized void dispose() {
        this.m_isDisposed = true;
        this.stopTest();
        IHandlerService handlerService = (IHandlerService)this.getSite().getWorkbenchWindow().getService(IHandlerService.class);
        handlerService.deactivateHandler(this.m_rerunActivation);
        handlerService.deactivateHandler(this.m_rerunFailedActivation);
        TestNGPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.m_viewIcon.dispose();
        this.fOKColor.dispose();
        this.fFailureColor.dispose();
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void postAsyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    private void refreshCounters() {
        this.m_counterPanel.setMethodCount(this.currentSuiteRunInfo.getMethodCount());
        this.m_counterPanel.setPassedCount(this.currentSuiteRunInfo.getPassedCount());
        this.m_counterPanel.setFailedCount(this.currentSuiteRunInfo.getFailedCount());
        this.m_counterPanel.setSkippedCount(this.currentSuiteRunInfo.getSkippedCount());
        String msg = "";
        if (this.currentSuiteRunInfo.hasRun()) {
            msg = " (" + this.currentSuiteRunInfo.getRunDuration() + " ms)";
        }
        this.fProgressBar.refresh(this.currentSuiteRunInfo.getStatus(), msg);
    }

    private void postShowTestResultsView() {
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.showTestResultsView();
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestRunnerViewPart testRunner = null;
        if (page != null) {
            try {
                boolean focusOnView = TestNGPlugin.getDefault().getPreferenceStore().getBoolean("showViewWhenTestComplete");
                testRunner = (TestRunnerViewPart)page.findView(NAME);
                if (focusOnView) {
                    if (testRunner == null) {
                        IWorkbenchPart activePart = page.getActivePart();
                        testRunner = (TestRunnerViewPart)page.showView(NAME);
                        page.activate(activePart);
                    } else {
                        page.bringToTop((IWorkbenchPart)testRunner);
                    }
                } else {
                    page.showView(NAME, null, 3);
                }
            }
            catch (PartInitException pie) {
                TestNGPlugin.log(pie);
            }
        }
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    private CTabFolder createTestRunTabs(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadTestRunTabs(tabFolder);
        tabFolder.setSelection(0);
        this.m_activeRunTab = ALL_TABS.get(0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestRunnerViewPart.this.testTabChanged(event);
            }
        });
        return tabFolder;
    }

    private void loadTestRunTabs(CTabFolder tabFolder) {
        TestRunTab t;
        TestRunTab[] testRunTabArray = REPORTING_TABS;
        int n = REPORTING_TABS.length;
        int n2 = 0;
        while (n2 < n) {
            t = testRunTabArray[n2];
            this.createTabControl(t, tabFolder, this);
            ++n2;
        }
        testRunTabArray = LISTENING_TABS;
        n = LISTENING_TABS.length;
        n2 = 0;
        while (n2 < n) {
            t = testRunTabArray[n2];
            this.createTabControl(t, tabFolder, this);
            ++n2;
        }
    }

    private void createTabControl(TestRunTab testRunTab, CTabFolder tabFolder, TestRunnerViewPart testRunnerViewPart) {
        Composite composite = testRunTab.createTabControl((Composite)tabFolder, this);
        CTabItem tab = new CTabItem(tabFolder, 0);
        tab.setText(ResourceUtil.getString(testRunTab.getNameKey()));
        tab.setImage(testRunTab.getImage());
        tab.setToolTipText(ResourceUtil.getString(testRunTab.getTooltipKey()));
        tab.setControl((Control)composite);
    }

    private void testTabChanged(SelectionEvent event) {
        String selectedTestId = this.m_activeRunTab.getSelectedTestId();
        for (TestRunTab tab : ALL_TABS) {
            tab.setSelectedTest(selectedTestId);
            String name = ResourceUtil.getString(tab.getNameKey());
            if (((CTabFolder)event.widget).getSelection().getText() != name) continue;
            this.m_activeRunTab = tab;
            this.m_activeRunTab.activate();
        }
    }

    void reset(int suiteCount, final int testCount) {
        this.currentSuiteRunInfo.setSuitesTotalCount(suiteCount);
        this.currentSuiteRunInfo.setTestsTotalCount(testCount);
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.m_counterPanel.reset();
                TestRunnerViewPart.this.fProgressBar.reset(testCount);
                TestRunnerViewPart.this.clearStatus();
                for (TestRunTab tab : ALL_TABS) {
                    tab.aboutToStart();
                }
            }
        });
    }

    public void setFocus() {
        if (this.m_activeRunTab != null) {
            this.m_activeRunTab.setFocus();
        }
    }

    private boolean getWatchResults() {
        return TestNGPlugin.getPluginPreferenceStore().getWatchResults(this.getProjectName());
    }

    private String getWatchResultDirectory() {
        String projectName = this.getProjectName();
        return projectName != null ? TestNGPlugin.getPluginPreferenceStore().getWatchResultDirectory(projectName) : null;
    }

    public void createPartControl(Composite parent) {
        this.m_parentComposite = parent;
        this.addResizeListener(parent);
        GridLayoutFactory.fillDefaults().applyTo(this.m_parentComposite);
        this.configureToolBar();
        this.createProgressCountPanel(this.m_parentComposite);
        this.m_tabFolder = this.createTestRunTabs(this.m_parentComposite);
        TestNGPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.m_stateMemento != null) {
            this.restoreLayoutState(this.m_stateMemento);
        }
        this.m_stateMemento = null;
        if (this.getWatchResultDirectory() != null) {
            this.updateResultThread();
        }
    }

    public void saveState(IMemento memento) {
        int activePage = this.m_tabFolder.getSelectionIndex();
        memento.putInteger(TAG_PAGE, activePage);
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        for (TestRunTab tab : ALL_TABS) {
            tab.saveState(memento);
        }
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 2)};
        this.fNextAction = new ShowNextFailureAction(this);
        this.fPrevAction = new ShowPreviousFailureAction(this);
        this.m_rerunAction = new RerunAction();
        IHandlerService handlerService = (IHandlerService)this.getSite().getWorkbenchWindow().getService(IHandlerService.class);
        AbstractHandler rerunLastHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                TestRunnerViewPart.this.m_rerunAction.run();
                return null;
            }

            public boolean isEnabled() {
                return TestRunnerViewPart.this.m_rerunAction.isEnabled();
            }
        };
        this.m_rerunActivation = handlerService.activateHandler(RERUN_LAST_COMMAND, (IHandler)rerunLastHandler);
        this.m_rerunFailedAction = new RerunFailedAction();
        AbstractHandler rerunFailedHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                TestRunnerViewPart.this.m_rerunFailedAction.run();
                return null;
            }

            public boolean isEnabled() {
                return TestRunnerViewPart.this.m_rerunFailedAction.isEnabled();
            }
        };
        this.m_rerunFailedActivation = handlerService.activateHandler(RERUN_FAILED_COMMAND, (IHandler)rerunFailedHandler);
        this.m_runHistoryAction = new RunHistoryAction(this);
        this.m_openReportAction = new OpenReportAction();
        this.m_clearTreeAction = new ClearResultsAction(ALL_TABS);
        this.fNextAction.setEnabled(false);
        this.fPrevAction.setEnabled(false);
        this.m_rerunAction.setEnabled(false);
        this.m_rerunFailedAction.setEnabled(false);
        this.m_openReportAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPrevAction);
        toolBar.add((IAction)this.m_clearTreeAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPrevAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.m_rerunAction);
        toolBar.add((IAction)this.m_rerunFailedAction);
        toolBar.add((IAction)this.m_runHistoryAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.m_openReportAction);
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction fToggleOrientationAction = toggleOrientationActionArray[n2];
            viewMenu.add((IAction)fToggleOrientationAction);
            ++n2;
        }
        actionBars.updateActionBars();
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    private void createProgressCountPanel(Composite parent) {
        this.progressAndSearchComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.progressAndSearchComposite);
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(this.progressAndSearchComposite);
        Display display = parent.getDisplay();
        this.fFailureColor = new Color((Device)display, 159, 63, 63);
        this.fOKColor = new Color((Device)display, 95, 191, 95);
        Composite m_searchComposite = new Composite(this.progressAndSearchComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)m_searchComposite);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(m_searchComposite);
        new Label(m_searchComposite, 0).setText("Search:");
        this.m_searchText = new Text(m_searchComposite, 2052);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_searchText);
        this.m_searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (TestRunnerViewPart.this.currentSuiteRunInfo == null) {
                    return;
                }
                String filter = "";
                if (TestRunnerViewPart.this.currentSuiteRunInfo.getNbResults() < 1000 || TestRunnerViewPart.this.currentSuiteRunInfo.getNbResults() >= 1000 && TestRunnerViewPart.this.m_searchText.getText().length() >= 3) {
                    filter = TestRunnerViewPart.this.m_searchText.getText();
                }
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateSearchFilter(filter);
                }
            }
        });
        this.m_counterPanel = new CounterPanel(this.progressAndSearchComposite);
        this.m_progressComposite = new Composite(this.progressAndSearchComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.m_progressComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.m_progressComposite);
        this.fProgressBar = new ProgressBar(this.m_progressComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fProgressBar);
        ToolBar toolBar = new ToolBar(this.m_progressComposite, 0x800000);
        GridDataFactory.swtDefaults().applyTo((Control)toolBar);
        this.m_stopButton = new ToolItem(toolBar, 8);
        this.m_stopButton.setEnabled(false);
        this.m_stopButton.setImage(Images.getImage("stop"));
        this.m_stopButton.setToolTipText("Stop the current test run");
        this.m_stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestRunnerViewPart.this.stopTest();
                TestRunnerViewPart.this.stopProcess();
                TestRunnerViewPart.this.m_stopButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public IJavaProject getLaunchedProject() {
        if (this.m_workingProject == null) {
            this.initProject();
        }
        return this.m_workingProject;
    }

    public void setLaunchedProject(IJavaProject project) {
        this.m_workingProject = project;
    }

    public ILaunch getLastLaunch() {
        if (this.currentSuiteRunInfo != null) {
            return this.currentSuiteRunInfo.getLaunch();
        }
        return null;
    }

    private boolean isDisposed() {
        return this.m_isDisposed || this.m_counterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public boolean isCreated() {
        return this.m_counterPanel != null;
    }

    public void warnOfContentChange() {
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.warnOfContentChange();
        }
    }

    public boolean lastLaunchIsKeptAlive() {
        return false;
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 3 : 1;
    }

    public Image getTitleImage() {
        return this.m_viewIcon;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getProperty();
        String statusChanged = String.valueOf(this.getProjectName()) + ".watchResults";
        String directoryChanged = String.valueOf(this.getProjectName()) + ".watchResultDirectory";
        if (statusChanged.equals(name) || directoryChanged.equals(name)) {
            this.updateResultThread();
        }
    }

    private void postTestResult(final RunInfo runInfo, final boolean isSuccess) {
        this.currentSuiteRunInfo.add(runInfo);
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fProgressBar.step(isSuccess);
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateTestResult(runInfo, true);
                }
            }
        });
    }

    private void showResultsInTree() {
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateTestResult(TestRunnerViewPart.this.currentSuiteRunInfo.getResults());
                }
            }
        });
    }

    public void onInitialization(GenericMessage genericMessage) {
        int suiteCount = genericMessage.getSuiteCount();
        int testCount = genericMessage.getTestCount();
        this.reset(suiteCount, testCount);
        this.stopUpdateJobs();
        this.m_updateUIJob = new UpdateUIJob("Update TestNG");
        this.m_isRunningJob = new IsRunningJob("TestNG run wrapper job");
        this.m_runLock = Job.getJobManager().newLock();
        this.m_runLock.acquire();
        this.getProgressService().schedule((Job)this.m_isRunningJob);
        this.m_updateUIJob.schedule(200L);
    }

    public void onFinish(SuiteMessage suiteMessage) {
        m_summaryTab.setExcludedMethodsModel(suiteMessage);
        this.postAsyncRunnable(new Runnable(){

            @Override
            public void run() {
                TestRunnerViewPart.this.m_searchText.setToolTipText(TestRunnerViewPart.this.currentSuiteRunInfo.getNbResults() > 1000 ? ResourceUtil.getFormattedString("TestRunnerViewPart.typeCharacters.tooltip", 3) : "");
            }
        });
        if (this.currentSuiteRunInfo.isSuiteRunFinished()) {
            boolean hasErrors = this.currentSuiteRunInfo.hasErrors();
            this.fNextAction.setEnabled(hasErrors);
            this.fPrevAction.setEnabled(hasErrors);
            this.m_rerunFailedAction.setEnabled(hasErrors);
            this.postShowTestResultsView();
            this.stopTest();
            this.postSyncRunnable(new Runnable(){

                @Override
                public void run() {
                    if (TestRunnerViewPart.this.isDisposed()) {
                        return;
                    }
                    TestRunnerViewPart.this.refreshCounters();
                    TestRunnerViewPart.this.m_stopButton.setEnabled(false);
                }
            });
        }
        this.showResultsInTree();
    }

    public void onStart(TestMessage tm) {
        RunInfo ri = new RunInfo(tm.getSuiteName(), tm.getTestName());
        ri.m_methodCount = tm.getTestMethodCount();
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.updateProgressBar();
                TestRunnerViewPart.this.m_stopButton.setEnabled(true);
            }
        });
    }

    private void updateProgressBar() {
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                int newMaxBar = TestRunnerViewPart.this.currentSuiteRunInfo.getNewMax();
                TestRunnerViewPart.this.fProgressBar.setMaximum(newMaxBar, TestRunnerViewPart.this.currentSuiteRunInfo.getMethodTotalCount());
            }
        });
    }

    public void onFinish(TestMessage tm) {
        this.updateProgressBar();
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fProgressBar.stepTests();
                TestRunnerViewPart.this.m_stopButton.setEnabled(false);
            }
        });
    }

    private RunInfo createRunInfo(TestResultMessage trm, String stackTrace, int type) {
        String testName = trm.getName();
        if (testName == null) {
            testName = "Default test";
        }
        return new RunInfo(trm.getSuiteName(), testName, trm.getTestClass(), trm.getMethod(), trm.getTestDescription(), trm.getInstanceName(), trm.getParameters(), trm.getParameterTypes(), trm.getEndMillis() - trm.getStartMillis(), stackTrace, type, trm.getInvocationCount(), trm.getCurrentInvocationCount());
    }

    public void onTestSuccess(TestResultMessage trm) {
        this.postTestResult(this.createRunInfo(trm, null, 1), true);
    }

    public void onTestFailure(TestResultMessage trm) {
        String desc = trm.getTestDescription();
        if (desc != null) {
            this.getTestDescriptions().add(desc);
        }
        this.postTestResult(this.createRunInfo(trm, trm.getStackTrace(), 2), false);
    }

    public void onTestSkipped(TestResultMessage trm) {
        this.postTestResult(this.createRunInfo(trm, trm.getStackTrace(), 3), false);
    }

    public void onTestFailedButWithinSuccessPercentage(TestResultMessage trm) {
        this.postTestResult(this.createRunInfo(trm, trm.getStackTrace(), 4), false);
    }

    public Set<String> getTestDescriptions() {
        if (this.testDescriptions == null) {
            this.testDescriptions = new HashSet<String>();
        }
        return this.testDescriptions;
    }

    public void run() {
        ILaunch launch = this.getLastLaunch();
        if (launch != null && this.currentSuiteRunInfo.hasErrors()) {
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            try {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                Set<String> descriptions = this.getTestDescriptions();
                if (!descriptions.isEmpty()) {
                    config = LaunchUtil.addJvmArg(TestNGPlugin.getFailedTestsKey(), StringUtils.listToString(descriptions), wc);
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            LaunchUtil.launchFailedSuiteConfiguration(this.m_workingProject, launch.getLaunchMode());
        }
    }

    public void onTestStart(TestResultMessage trm) {
    }

    public void onStart(SuiteMessage suiteMessage) {
        m_summaryTab.setExcludedMethodsModel(suiteMessage);
    }

    private String getProjectName() {
        IJavaProject project = this.getLaunchedProject();
        return project != null ? project.getProject().getName() : null;
    }

    void reset(final SuiteRunInfo run) {
        this.postSyncRunnable(new Runnable(){

            @Override
            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.currentSuiteRunInfo = run;
                TestRunnerViewPart.this.refreshCounters();
                TestRunnerViewPart.this.clearStatus();
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateTestResult(TestRunnerViewPart.this.currentSuiteRunInfo.getResults());
                }
            }
        });
    }

    class IsRunningJob
    extends Job {
        public IsRunningJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            TestRunnerViewPart.this.m_runLock.acquire();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_RUN;
        }
    }

    private class OpenReportAction
    extends Action {
        public OpenReportAction() {
            this.setText(ResourceUtil.getString("TestRunnerViewPart.openreport.label"));
            this.setToolTipText(ResourceUtil.getString("TestRunnerViewPart.openreport.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/report.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/report.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/report.gif"));
        }

        private void openEditor(IFile file) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            }
            catch (PartInitException e) {
                TestNGPlugin.log(e);
            }
        }

        public void run() {
            IJavaProject javaProject;
            IJavaProject iJavaProject = javaProject = TestRunnerViewPart.this.m_workingProject != null ? TestRunnerViewPart.this.m_workingProject : JDTUtil.getJavaProjectContext();
            if (javaProject == null) {
                return;
            }
            PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
            Path filePath = new Path(String.valueOf(storage.getOutputDirectoryPath(javaProject).toOSString()) + "/index.html");
            boolean isAbsolute = storage.isOutputAbsolutePath(javaProject.getElementName(), false);
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            if (isAbsolute) {
                IFile file = javaProject.getProject().getFile("temp-testng-index.html");
                try {
                    if (file == null) {
                        return;
                    }
                    file.createLink((IPath)filePath, 0, (IProgressMonitor)progressMonitor);
                    try {
                        this.openEditor(file);
                    }
                    finally {
                        file.delete(true, (IProgressMonitor)progressMonitor);
                    }
                }
                catch (CoreException cex) {
                    TestNGPlugin.log(cex);
                }
            } else {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
                if (file == null) {
                    return;
                }
                try {
                    file.refreshLocal(0, (IProgressMonitor)progressMonitor);
                    this.openEditor(file);
                }
                catch (CoreException cex) {
                    TestNGPlugin.log(cex);
                }
            }
        }
    }

    private class RerunAction
    extends Action {
        public RerunAction() {
            this.setText(ResourceUtil.getString("TestRunnerViewPart.rerunaction.label"));
            this.setToolTipText(ResourceUtil.getString("TestRunnerViewPart.rerunaction.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("dlcl16/relaunch.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setActionDefinitionId(TestRunnerViewPart.RERUN_LAST_COMMAND);
        }

        public void run() {
            ILaunch launch = TestRunnerViewPart.this.getLastLaunch();
            if (launch != null) {
                DebugUITools.launch((ILaunchConfiguration)launch.getLaunchConfiguration(), (String)launch.getLaunchMode());
            }
        }
    }

    private class RerunFailedAction
    extends Action {
        public RerunFailedAction() {
            this.setText(ResourceUtil.getString("TestRunnerViewPart.rerunfailedsaction.label"));
            this.setToolTipText(ResourceUtil.getString("TestRunnerViewPart.rerunfailedsaction.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("dlcl16/relaunchf.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunchf.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunchf.gif"));
            this.setActionDefinitionId(TestRunnerViewPart.RERUN_FAILED_COMMAND);
        }

        public void run() {
            ILaunch launch = TestRunnerViewPart.this.getLastLaunch();
            if (launch != null && TestRunnerViewPart.this.currentSuiteRunInfo.hasErrors()) {
                LaunchUtil.launchFailedSuiteConfiguration(TestRunnerViewPart.this.m_workingProject, launch.getLaunchMode(), launch.getLaunchConfiguration(), TestRunnerViewPart.this.getTestDescriptions());
            }
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(TestRunnerViewPart v, int orientation) {
            super("", 8);
            if (orientation == 1) {
                this.setText(ResourceUtil.getString("TestRunnerViewPart.toggle.horizontal.label"));
                this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/th_horizontal.gif"));
            } else if (orientation == 0) {
                this.setText(ResourceUtil.getString("TestRunnerViewPart.toggle.vertical.label"));
                this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/th_vertical.gif"));
            } else if (orientation == 2) {
                this.setText(ResourceUtil.getString("TestRunnerViewPart.toggle.automatic.label"));
                this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/th_automatic.gif"));
            }
            this.fActionOrientation = orientation;
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestRunnerViewPart.this.fOrientation = this.fActionOrientation;
                TestRunnerViewPart.this.computeOrientation();
            }
        }
    }

    class UpdateUIJob
    extends UIJob {
        private volatile boolean fRunning;

        public UpdateUIJob(String name) {
            super(name);
            this.fRunning = true;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TestRunnerViewPart.this.isDisposed()) {
                TestRunnerViewPart.this.refreshCounters();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.fRunning = false;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }
    }
}

