/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.preferences;

import java.io.File;
import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.util.Utils;
import org.testng.eclipse.util.ResourceUtil;

public class WorkspacePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FSBrowseDirectoryFieldEditor m_outputdir;
    private BooleanFieldEditor2 m_absolutePath;
    private BooleanFieldEditor2 m_disabledDefaultListeners;
    private BooleanFieldEditor2 m_showViewWhenTestsComplete;
    private BooleanFieldEditor2 m_showCaseNameOnViewTitle;
    private ResourceSelectionFieldEditor m_xmlTemplateFile;
    private StringFieldEditor m_excludedStackTraces;
    private StringFieldEditor m_preDefinedListeners;

    public WorkspacePreferencePage() {
        super(1);
        this.setPreferenceStore(TestNGPlugin.getDefault().getPreferenceStore());
        this.setDescription("TestNG workbench preferences");
    }

    public void createFieldEditors() {
        Composite parentComposite = this.getFieldEditorParent();
        this.m_outputdir = new FSBrowseDirectoryFieldEditor(".outdir", "Output directory:", parentComposite);
        this.m_outputdir.fillIntoGrid(parentComposite, 3);
        Button btn = this.m_outputdir.getChangeControl(parentComposite);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkspacePreferencePage.this.m_absolutePath.getChangeControl(WorkspacePreferencePage.this.getFieldEditorParent()).setSelection(true);
            }
        });
        this.m_absolutePath = new BooleanFieldEditor2(".absolutepath", "Absolute output path", 0, parentComposite);
        this.m_outputdir.setAbsolutePathVerifier(this.m_absolutePath);
        this.m_xmlTemplateFile = new ResourceSelectionFieldEditor("xmlTemplateFile", ResourceUtil.getString("TestNGPropertyPage.templateXml"), parentComposite);
        this.m_xmlTemplateFile.setEmptyStringAllowed(true);
        this.m_xmlTemplateFile.fillIntoGrid(parentComposite, 3);
        this.m_disabledDefaultListeners = new BooleanFieldEditor2(".disabledListeners", ResourceUtil.getString("TestNGPropertyPage.disableDefaultListeners"), 0, parentComposite);
        this.m_preDefinedListeners = new StringFieldEditor("preDefinedListeners", ResourceUtil.getString("TestNGPropertyPage.preDefinedListeners"), parentComposite);
        Label sepLabel = new Label(parentComposite, 258);
        GridDataFactory.fillDefaults().span(3, -1).applyTo((Control)sepLabel);
        this.m_showViewWhenTestsComplete = new BooleanFieldEditor2("showViewWhenTestComplete", "Show view when tests complete", 0, parentComposite);
        this.m_showCaseNameOnViewTitle = new BooleanFieldEditor2("showCaseNameOnViewTitle", "Show test name on view title when tests complete", 0, parentComposite);
        this.m_excludedStackTraces = new StringFieldEditor("excludedStackTraces", "Excluded stack traces:", parentComposite);
        this.m_excludedStackTraces.fillIntoGrid(parentComposite, 3);
        GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(36), -1).applyTo((Control)this.m_excludedStackTraces.getTextControl(parentComposite));
        this.addField((FieldEditor)this.m_outputdir);
        this.addField((FieldEditor)this.m_absolutePath);
        this.addField((FieldEditor)this.m_disabledDefaultListeners);
        this.addField((FieldEditor)this.m_showViewWhenTestsComplete);
        this.addField((FieldEditor)this.m_showCaseNameOnViewTitle);
        this.addField((FieldEditor)this.m_xmlTemplateFile);
        this.addField((FieldEditor)this.m_excludedStackTraces);
        this.addField((FieldEditor)this.m_preDefinedListeners);
    }

    public void init(IWorkbench workbench) {
    }

    private static class FSBrowseDirectoryFieldEditor
    extends DirectoryFieldEditor {
        BooleanFieldEditor2 absolutePath;

        public FSBrowseDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void setAbsolutePathVerifier(BooleanFieldEditor2 isAbsolute) {
            this.absolutePath = isAbsolute;
        }

        public Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }

        protected boolean doCheckState() {
            String fileName = this.getTextControl().getText();
            if ((fileName = fileName.trim()).length() == 0 && this.isEmptyStringAllowed()) {
                return true;
            }
            if (this.absolutePath.getBooleanValue()) {
                File file = new File(fileName);
                return file.isDirectory();
            }
            return true;
        }
    }

    private static class ResourceSelectionFieldEditor
    extends StringButtonFieldEditor {
        public ResourceSelectionFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setChangeButtonText("Browse...");
        }

        protected String changePressed() {
            return Utils.selectTemplateFile(this.getShell());
        }
    }
}

