/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.SWTUtil;

public class Utils {
    private static Composite createParent(Composite parent, boolean group) {
        Object result = group ? new Group(parent, 64) : new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)SWTUtil.createGridData());
        return result;
    }

    public static Widgets createTextBrowseControl(Composite suppliedParent, String checkKey, String labelKey, SelectionListener buttonListener, final SelectionListener checkListener, ModifyListener textListener, boolean enabled) {
        final Widgets result = new Widgets();
        Composite parent = Utils.createParent(suppliedParent, checkKey != null);
        if (checkKey != null) {
            result.radio = new Button(parent, 32);
            result.radio.setText(ResourceUtil.getString(checkKey));
            GridData gd = new GridData();
            gd.horizontalSpan = 3;
            result.radio.setLayoutData((Object)gd);
            result.radio.setSelection(true);
            result.radio.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (checkListener != null) {
                        checkListener.widgetDefaultSelected(e);
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    if (checkListener != null) {
                        checkListener.widgetSelected(e);
                    }
                    Utils.enableControls(result, ((Button)e.getSource()).getSelection());
                }
            });
        }
        Label label = new Label(parent, 0);
        label.setText(ResourceUtil.getString(labelKey));
        result.text = new Text(parent, 2052);
        GridData gd = new GridData(768);
        result.text.setLayoutData((Object)gd);
        if (buttonListener == null) {
            gd.grabExcessHorizontalSpace = true;
        }
        if (textListener != null) {
            result.text.addModifyListener(textListener);
        }
        if (buttonListener != null) {
            result.button = new Button(parent, 8);
            result.button.setText(ResourceUtil.getString("TestNGMainTab.label.browse"));
            result.button.addSelectionListener(buttonListener);
        }
        Utils.enableControls(result, enabled);
        return result;
    }

    public static Widgets createStringEditorControl(Composite suppliedParent, String labelKey, ModifyListener textListener, boolean enabled) {
        Widgets result = new Widgets();
        Composite parent = Utils.createParent(suppliedParent, true);
        Label label = new Label(parent, 0);
        label.setText(ResourceUtil.getString(labelKey));
        result.text = new Text(parent, 2052);
        GridData gd = new GridData(768);
        result.text.setLayoutData((Object)gd);
        if (textListener != null) {
            result.text.addModifyListener(textListener);
        }
        Utils.enableControls(result, enabled);
        return result;
    }

    private static void enableControls(Widgets result, boolean enabled) {
        if (result.text != null) {
            result.text.setEnabled(enabled);
        }
        if (result.button != null) {
            result.button.setEnabled(enabled);
        }
    }

    public static Widgets createWidgetTriple(Composite parent, String labelKey, SelectionListener radioListener, SelectionListener buttonListener, ModifyListener textListener) {
        Widgets result = new Widgets();
        result.radio = new Button(parent, 16);
        result.radio.setText(ResourceUtil.getString(labelKey));
        result.radio.addSelectionListener(radioListener);
        result.text = new Text(parent, 2052);
        GridData gd = new GridData(768);
        result.text.setLayoutData((Object)gd);
        if (textListener != null) {
            result.text.addModifyListener(textListener);
        }
        result.button = new Button(parent, 8);
        result.button.setText(ResourceUtil.getString("TestNGMainTab.label.browse"));
        result.button.addSelectionListener(buttonListener);
        return result;
    }

    public static ITreeContentProvider getResourceContentProvider(final String extension) {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                Object[] children = super.getChildren(element);
                ArrayList<Object> elements = new ArrayList<Object>();
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IProject) {
                        if (((IProject)obj).isOpen()) {
                            elements.add(obj);
                        }
                    } else if (obj instanceof IFile) {
                        if (extension.equalsIgnoreCase(((IFile)obj).getFileExtension())) {
                            elements.add(obj);
                        }
                    } else {
                        elements.add(obj);
                    }
                    ++n2;
                }
                return elements.toArray(new Object[elements.size()]);
            }
        };
    }

    public static String selectTemplateFile(Shell shell) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), Utils.getResourceContentProvider("xml"));
        dialog.setTitle("Select TestNG suite template file");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        String result = null;
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IFile) {
            IFile file = (IFile)results[0];
            IProject prj = file.getProject();
            IPath relativePath = file.getProjectRelativePath();
            String wsRelativePath = String.valueOf(prj.getName()) + "/" + relativePath;
            result = "${workspace_loc:" + wsRelativePath + "}";
        }
        return result;
    }

    public static String stripDoubleQuotes(String v) {
        String result = v;
        int ind1 = v.indexOf("\"");
        int ind2 = v.lastIndexOf("\"");
        if (ind1 != -1 && ind2 != -1 && ind1 < ind2) {
            result = v.substring(ind1 + 1, ind2);
        }
        return result;
    }

    public static String[] split(String string, String sep) {
        return org.testng.internal.Utils.split((String)string, (String)sep);
    }

    public static void ppp(String s) {
        System.out.println("[Utils] " + s);
    }

    public static String absolutePath(String rootPath, String sourcePath) {
        File sourceFile = null;
        if (sourcePath != null && !"".equals(sourcePath.trim())) {
            sourceFile = new File(sourcePath);
        }
        if (sourceFile != null && sourceFile.isAbsolute()) {
            return sourceFile.getAbsolutePath();
        }
        rootPath.lastIndexOf(47);
        return new File(rootPath, sourcePath).getAbsolutePath();
    }

    public static String toSinglePath(List files, String sep) {
        if (files == null || files.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer(((File)files.get(0)).getAbsolutePath());
        int i = 1;
        while (i < files.size()) {
            buf.append(sep).append(((File)files.get(i)).getAbsolutePath());
            ++i;
        }
        return buf.toString();
    }

    public static List<String> uniqueMergeList(Collection<List<String>> collection) {
        HashSet<String> uniques = new HashSet<String>();
        for (List<String> l : collection) {
            uniques.addAll(l);
        }
        return new ArrayList<String>(uniques);
    }

    public static boolean createFileWithDialog(Shell shell, IFile file, InputStream stream) throws CoreException {
        boolean success = false;
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            if (file.exists()) {
                boolean overwrite = MessageDialog.openConfirm((Shell)shell, (String)ResourceUtil.getString("NewTestNGClassWizard.alreadyExists.title"), (String)ResourceUtil.getFormattedString("NewTestNGClassWizard.alreadyExists.message", file.getFullPath().toString()));
                if (overwrite) {
                    file.setContents(stream, true, true, (IProgressMonitor)monitor);
                    success = true;
                }
            } else {
                Utils.createResourceRecursively((IResource)file, (IProgressMonitor)monitor);
                file.setContents(stream, 3, (IProgressMonitor)monitor);
                success = true;
            }
            stream.close();
        }
        catch (IOException iOException) {}
        return success;
    }

    protected static void createResourceRecursively(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            Utils.createResourceRecursively((IResource)resource.getParent(), monitor);
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
                break;
            }
            case 2: {
                ((IFolder)resource).create(0, true, monitor);
                break;
            }
            case 4: {
                ((IProject)resource).create(monitor);
                ((IProject)resource).open(monitor);
            }
        }
    }

    public static class WidgetPair {
        public Text text;
        public Button button;
    }

    public static class Widgets
    extends WidgetPair {
        public Button radio;
    }
}

