/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.testng.TestNGException;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.LaunchSuite;
import org.testng.xml.Parser;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;

public abstract class CustomSuite
extends LaunchSuite {
    public static final String DEFAULT_SUITE_TAG_NAME = "Default suite";
    public static final String DEFAULT_TEST_TAG_NAME = "Default test";
    protected String m_projectName;
    protected String m_suiteName;
    protected Map<String, String> m_parameters;
    protected int m_logLevel;
    private String workingDir;
    private XMLStringBuffer m_suiteBuffer;

    public CustomSuite(String projectName, String suiteName, Map<String, String> parameters, int logLevel, String workingDir) {
        super(true);
        this.init(Collections.emptyList(), projectName, suiteName, parameters, logLevel);
        this.workingDir = workingDir;
    }

    private void init(List<String> suiteFiles, String projectName, String suiteName, Map<String, String> parameters, int logLevel) {
        this.m_projectName = projectName;
        this.m_suiteName = suiteName;
        this.m_parameters = parameters;
        this.m_logLevel = logLevel;
    }

    protected abstract String getTestName();

    protected String getSuiteName() {
        return this.m_suiteName;
    }

    private void put(Properties p, String key, Object value) {
        if (value != null) {
            p.put(key, value);
        }
    }

    protected XMLStringBuffer createContentBuffer() {
        PreferenceStoreUtil storage = new PreferenceStoreUtil(TestNGPlugin.getDefault().getPreferenceStore());
        String xmlFile = storage.getXmlTemplateFile(this.m_projectName, false);
        boolean hasEclipseXmlFile = !Utils.isStringEmpty((String)xmlFile);
        XMLStringBuffer suiteBuffer = new XMLStringBuffer();
        suiteBuffer.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        if (hasEclipseXmlFile) {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                String resolvedXmlFile = manager.performStringSubstitution(xmlFile);
                if (!new Path(resolvedXmlFile).isAbsolute() && !Utils.isStringEmpty((String)this.workingDir)) {
                    resolvedXmlFile = String.valueOf(this.workingDir) + "/" + resolvedXmlFile;
                }
                this.createXmlFileFromTemplate(suiteBuffer, resolvedXmlFile);
            }
            catch (CoreException e) {
                TestNGPlugin.log(e);
            }
        } else {
            this.createXmlFileFromParameters(suiteBuffer);
        }
        this.initContentBuffer(suiteBuffer);
        suiteBuffer.pop("suite");
        return suiteBuffer;
    }

    private void createXmlFileFromParameters(XMLStringBuffer suiteBuffer) {
        Properties attrs = new Properties();
        attrs.setProperty("name", this.getSuiteName());
        suiteBuffer.push("suite", attrs);
        if (this.m_parameters != null) {
            for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
                Properties paramAttrs = new Properties();
                paramAttrs.setProperty("name", entry.getKey());
                paramAttrs.setProperty("value", entry.getValue());
                suiteBuffer.addEmptyElement("parameter", paramAttrs);
            }
        }
    }

    private void createXmlFileFromTemplate(XMLStringBuffer suiteBuffer, String fileName) throws CoreException {
        try {
            Parser parser = new Parser(fileName);
            parser.setLoadClasses(false);
            Collection suites = parser.parse();
            if (suites.size() > 0) {
                Properties p;
                XmlSuite s = (XmlSuite)suites.iterator().next();
                Properties attr = new Properties();
                this.put(attr, "name", s.getName());
                this.put(attr, "junit", s.isJUnit());
                this.put(attr, "verbose", s.getVerbose());
                this.put(attr, "parallel", s.getParallel());
                this.put(attr, "thread-count", s.getThreadCount());
                this.put(attr, "time-out", s.getTimeOut());
                this.put(attr, "skipfailedinvocationcounts", s.skipFailedInvocationCounts());
                this.put(attr, "configfailurepolicy", s.getConfigFailurePolicy());
                this.put(attr, "data-provider-thread-count", s.getDataProviderThreadCount());
                this.put(attr, "object-factory", s.getObjectFactory());
                this.put(attr, "allow-return-values", s.getAllowReturnValues());
                this.put(attr, "preserve-order", s.getPreserveOrder());
                this.put(attr, "group-by-instances", s.getGroupByInstances());
                suiteBuffer.push("suite", attr);
                if (s.getListeners().size() > 0) {
                    suiteBuffer.push("listeners");
                    for (String l : s.getListeners()) {
                        p = new Properties();
                        p.put("class-name", l);
                        suiteBuffer.addEmptyElement("listener", p);
                    }
                    suiteBuffer.pop("listeners");
                }
                for (Map.Entry parameter : s.getParameters().entrySet()) {
                    p = new Properties();
                    p.put("name", parameter.getKey());
                    p.put("value", parameter.getValue());
                    suiteBuffer.addEmptyElement("parameter", p);
                }
                if (s.getMethodSelectors().size() > 0) {
                    suiteBuffer.push("method-selectors");
                    for (XmlMethodSelector ms : s.getMethodSelectors()) {
                        String cls = ms.getClassName();
                        if (cls == null || cls.length() <= 0) continue;
                        suiteBuffer.push("method-selector");
                        Properties p2 = new Properties();
                        p2.put("name", cls);
                        p2.put("priority", (Object)ms.getPriority());
                        suiteBuffer.addEmptyElement("selector-class", p2);
                        suiteBuffer.pop("method-selector");
                    }
                    suiteBuffer.pop("method-selectors");
                }
            }
        }
        catch (IOException e) {
            throw new TestNGException((Throwable)e);
        }
    }

    public XMLStringBuffer getSuiteBuffer() {
        if (this.m_suiteBuffer == null) {
            this.m_suiteBuffer = this.createContentBuffer();
        }
        return this.m_suiteBuffer;
    }

    public String getFileName() {
        return "testng-customsuite.xml";
    }

    public File save(File directory) {
        directory.mkdirs();
        File suiteFile = new File(directory, this.getFileName());
        this.saveSuiteContent(suiteFile, this.getSuiteBuffer());
        return suiteFile;
    }

    protected void saveSuiteContent(File file, XMLStringBuffer content) {
        FileOutputStream fileOutputStream = null;
        FilterOutputStream bufferedOutputStream = null;
        OutputStreamWriter osw = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                osw = new OutputStreamWriter((OutputStream)bufferedOutputStream, Charset.forName("UTF-8"));
                osw.write(content.getStringBuffer().toString());
            }
            catch (IOException ioException) {
                TestNGPlugin.log(ioException);
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception e) {
                    TestNGPlugin.log(e);
                }
            }
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {
                TestNGPlugin.log(e);
            }
        }
    }

    protected void initContentBuffer(XMLStringBuffer suiteBuffer) {
        Properties testAttrs = new Properties();
        testAttrs.setProperty("name", this.getTestName());
        testAttrs.setProperty("verbose", String.valueOf(this.m_logLevel));
        suiteBuffer.push("test", testAttrs);
        this.groupsElement(suiteBuffer);
        this.packagesElement(suiteBuffer);
        this.classesElement(suiteBuffer);
        suiteBuffer.pop("test");
    }

    protected void groupsElement(XMLStringBuffer suiteBuffer) {
    }

    protected void packagesElement(XMLStringBuffer suiteBuffer) {
    }

    protected void classesElement(XMLStringBuffer suiteBuffer) {
    }

    protected void generateDefaultGroupsElement(XMLStringBuffer suiteBuffer, Collection<String> groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return;
        }
        suiteBuffer.push("groups");
        suiteBuffer.push("run");
        for (String groupName : groupNames) {
            Properties includeAttrs = new Properties();
            includeAttrs.setProperty("name", groupName);
            suiteBuffer.addEmptyElement("include", includeAttrs);
        }
        suiteBuffer.pop("run");
        suiteBuffer.pop("groups");
    }

    protected void generateDefaultPackagesElement(XMLStringBuffer suiteBuffer, List<String> packageNames) {
        if (packageNames == null || packageNames.isEmpty()) {
            return;
        }
        suiteBuffer.push("packages");
        for (String packageName : packageNames) {
            Properties packageAttrs = new Properties();
            packageAttrs.setProperty("name", packageName);
            suiteBuffer.addEmptyElement("package", packageAttrs);
        }
        suiteBuffer.pop("packages");
    }

    protected void generateDefaultClassesElement(XMLStringBuffer suiteBuffer, List<String> classNames) {
        if (classNames == null || classNames.isEmpty()) {
            return;
        }
        suiteBuffer.push("classes");
        for (String className : classNames) {
            Properties classAttrs = new Properties();
            classAttrs.setProperty("name", className);
            suiteBuffer.addEmptyElement("class", classAttrs);
        }
        suiteBuffer.pop("classes");
    }
}

