/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.util.DependencyVisitor;

public class JDTUtil {
    public static final String PROJECT_TYPE = "P";
    public static final String DIRECTORY_TYPE = "D";
    public static final String CLASS_TYPE = "C";
    public static final String SOURCE_TYPE = "J";
    public static final String SUITE_TYPE = "S";
    public static final int NO_CTX = 0;
    public static final int TEST_CLASS_CTX = 1;
    public static final int TEST_SUITE_CTX = 2;

    private JDTUtil() {
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)JDTUtil.getWorkspaceRoot());
    }

    public static IJavaProject getJavaProject(String projectName) {
        if (projectName == null || projectName.length() < 1) {
            return null;
        }
        return JDTUtil.getJavaModel().getJavaProject(projectName);
    }

    public static IJavaProject[] getJavaProjects() {
        IJavaProject[] projects = null;
        try {
            projects = JavaCore.create((IWorkspaceRoot)JDTUtil.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        return projects;
    }

    public static IJavaProject getJavaProjectContext() {
        IStructuredSelection ss;
        ISelection selection;
        IWorkbenchPage page = JDTUtil.getActivePage();
        if (page != null && (selection = page.getSelection()) != null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            Object obj = ss.getFirstElement();
            if (obj instanceof IJavaElement) {
                return ((IJavaElement)obj).getJavaProject();
            }
            if (obj instanceof IResource) {
                IProject pro = ((IResource)obj).getProject();
                IJavaProject ijp = JavaCore.create((IProject)pro);
                return ijp;
            }
        }
        return null;
    }

    public static String getResourceType(IResource resource) {
        if (resource instanceof IProject) {
            return PROJECT_TYPE;
        }
        if (resource instanceof IFolder) {
            return DIRECTORY_TYPE;
        }
        IFile file = (IFile)resource;
        if ("class".equals(file.getFileExtension())) {
            return CLASS_TYPE;
        }
        if ("java".equals(file.getFileExtension())) {
            return SOURCE_TYPE;
        }
        if ("xml".equals(file.getFileExtension())) {
            return SUITE_TYPE;
        }
        return "";
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = TestNGPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static int getResourceContextType() {
        IStructuredSelection ss;
        ISelection selection;
        IWorkbenchPage page = JDTUtil.getActivePage();
        if (page != null && (selection = page.getSelection()) != null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            Object obj = ss.getFirstElement();
            if (obj instanceof IJavaElement) {
                IJavaElement ije = (IJavaElement)obj;
                JDTUtil.ppp("getResourceContextType():IJavaElement: " + ije.getElementName());
                JDTUtil.ppp("getResourceContextType():Element type: " + ije.getElementType());
                if (5 <= ije.getElementType()) {
                    return 1;
                }
                return 0;
            }
            if (obj instanceof IResource) {
                IResource ir = (IResource)obj;
                if (1 == ir.getType()) {
                    if ("class".equals(ir.getFileExtension())) {
                        return 1;
                    }
                    if ("xml".equals(ir.getFileExtension())) {
                        return 2;
                    }
                    return 0;
                }
                return 0;
            }
        }
        return 0;
    }

    public static ICompilationUnit getJavaElement(IFile file) {
        IJavaElement ije = JavaCore.create((IFile)file);
        return (ICompilationUnit)ije.getAncestor(5);
    }

    public static Object getResourceContext() {
        IStructuredSelection ss;
        ISelection selection;
        IWorkbenchPage page = JDTUtil.getActivePage();
        if (page != null && (selection = page.getSelection()) != null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            IResource ir;
            Object obj = ss.getFirstElement();
            if (obj instanceof IJavaElement) {
                IJavaElement ije = (IJavaElement)obj;
                JDTUtil.ppp("IJavaElement: " + ije.getElementName());
                JDTUtil.ppp("Element type: " + ije.getElementType());
                if (5 <= ije.getElementType()) {
                    return ije.getAncestor(5);
                }
            }
            if (obj instanceof IResource && 1 == (ir = (IResource)obj).getType()) {
                if ("class".equals(ir.getFileExtension())) {
                    IJavaElement ije = JavaCore.create((IFile)((IFile)ir));
                    return ije.getAncestor(5);
                }
                if ("xml".equals(ir.getFileExtension())) {
                    return ir;
                }
            }
        }
        return null;
    }

    private static void ppp(Object msg) {
        System.out.println("[JDTUtil]: " + msg);
    }

    public static List<File> getSourceDirFileList(IJavaProject jproject) {
        if (jproject == null || !jproject.exists()) {
            return Collections.emptyList();
        }
        ArrayList sourcePaths = Lists.newArrayList();
        try {
            IPackageFragmentRoot[] sourceRoots = jproject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < sourceRoots.length) {
                IResource sourceRes;
                if (1 == sourceRoots[i].getKind() && (sourceRes = sourceRoots[i].getCorrespondingResource()) != null) {
                    sourcePaths.add(sourceRes.getLocation().toFile());
                }
                ++i;
            }
        }
        catch (JavaModelException jme) {
            TestNGPlugin.log(jme);
        }
        return sourcePaths;
    }

    public static IJavaElement findElement(IJavaProject javaProject, String className, String methodName, String[] paramTypes) throws JavaModelException {
        IType type = javaProject.findType(className);
        if (type == null) {
            return null;
        }
        if (methodName == null) {
            return type;
        }
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        ArrayList<String> params = new ArrayList<String>(paramTypes.length);
        String[] stringArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String paramType = stringArray[n2];
            int idx = paramType.lastIndexOf(46);
            String typeName = idx == -1 ? paramType : paramType.substring(idx + 1);
            params.add(Signature.createTypeSignature((String)typeName, (boolean)false));
            ++n2;
        }
        IMethod method = JDTUtil.findMethodInTypeHierarchy(type, methodName, params.toArray(new String[paramTypes.length]));
        if (method == null) {
            method = JDTUtil.fuzzyFindMethodInTypeHierarchy(type, methodName, paramTypes);
        }
        return method;
    }

    public static IJavaElement findElement(IJavaProject javaProject, RunInfo runInfo) throws JavaModelException {
        return JDTUtil.findElement(javaProject, runInfo.getClassName(), runInfo.getMethodName(), runInfo.getParameterTypes());
    }

    public static IJavaElement findElement(IJavaProject javaProject, String className) throws JavaModelException {
        return javaProject.findType(className);
    }

    private static IMethod findMethodInTypeHierarchy(IType type, String methodName, String[] paramTypes) throws JavaModelException {
        IType[] types;
        IMethod method = type.getMethod(methodName, paramTypes);
        if (method != null && method.exists()) {
            return method;
        }
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
        IType[] iTypeArray = types = typeHierarchy.getAllSuperclasses(type);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            method = t.getMethod(methodName, paramTypes);
            if (method != null && method.exists()) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static IMethod fuzzyFindMethodInTypeHierarchy(IType type, String methodName, String[] paramTypes) throws JavaModelException {
        IType[] types;
        IMethod[] methods;
        ArrayList<IMethod> fuzzyResults = new ArrayList<IMethod>();
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (methodName.equals(m.getElementName()) && m.exists()) {
                if (m.getNumberOfParameters() == paramTypes.length) {
                    return m;
                }
                fuzzyResults.add(m);
            }
            ++n2;
        }
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
        IType[] iTypeArray = types = typeHierarchy.getAllSuperclasses(type);
        int n3 = types.length;
        int n4 = 0;
        while (n4 < n3) {
            IType t = iTypeArray[n4];
            IMethod[] iMethodArray2 = methods = t.getMethods();
            int n5 = methods.length;
            int n6 = 0;
            while (n6 < n5) {
                IMethod m = iMethodArray2[n6];
                if (methodName.equals(m.getElementName()) && m.exists()) {
                    return m;
                }
                ++n6;
            }
            ++n4;
        }
        return fuzzyResults.isEmpty() ? null : (IMethod)fuzzyResults.get(0);
    }

    public static IMethod fuzzyFindMethodInProject(IJavaProject project, IType methodType, IMethod currentMethod, String methodName) throws JavaModelException {
        int dotIdx = methodName.lastIndexOf(46);
        if (dotIdx > 0) {
            String fullyQualifiedName = methodName.substring(0, dotIdx);
            methodType = project.findType(fullyQualifiedName);
            methodName = methodName.substring(dotIdx + 1);
        }
        if (methodType == null) {
            TestNGPlugin.log("Could not find the enclosed class for: " + methodName);
            return null;
        }
        IMethod depMethod = JDTUtil.fuzzyFindMethodInTypeHierarchy(methodType, methodName, new String[0]);
        if (depMethod == null) {
            TestNGPlugin.log("Could not find method: " + methodType.getFullyQualifiedName() + "." + methodName);
        }
        return depMethod;
    }

    public static List<MethodDefinition> solveDependencies(IMethod method) {
        HashSet parsedMethods = Sets.newHashSet();
        MethodDefinition md = new MethodDefinition(method);
        parsedMethods.add(method.getElementName());
        ArrayList results = Lists.newArrayList();
        results.add(md);
        results.addAll(JDTUtil.solveDependencies(md, parsedMethods));
        return results;
    }

    private static List<MethodDefinition> solveDependencies(MethodDefinition methodDef, Set<String> parsedMethods) {
        DependencyVisitor dv = JDTUtil.parse(methodDef.getMethod());
        ArrayList results = Lists.newArrayList();
        List<String> dependsOnMethods = dv.getDependsOnMethods();
        if (!dependsOnMethods.isEmpty()) {
            for (String methodName : dependsOnMethods) {
                IMethod meth;
                if (parsedMethods.contains(methodName) || (meth = JDTUtil.solveMethod(methodDef.getMethod().getDeclaringType(), methodName)) == null) continue;
                MethodDefinition md = new MethodDefinition(meth);
                parsedMethods.add(meth.getElementName());
                results.add(md);
                methodDef.addDependencyMethod(md);
                results.addAll(JDTUtil.solveDependencies(md, parsedMethods));
            }
        }
        methodDef.addDependencyGroups(dv.getDependsOnGroups());
        return results;
    }

    private static DependencyVisitor parse(IMethod method) {
        DependencyVisitor dv = new DependencyVisitor();
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(method.getSource().toCharArray());
            parser.setKind(4);
            ASTNode node = parser.createAST(null);
            node.accept((ASTVisitor)dv);
        }
        catch (JavaModelException javaModelException) {}
        return dv;
    }

    public static IMethod solveMethod(IType type, String methodName) {
        try {
            IType[] superTypes;
            IMethod[] typemethods;
            IMethod[] iMethodArray = typemethods = type.getMethods();
            int n = typemethods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (methodName.equals(m.getElementName())) {
                    return m;
                }
                ++n2;
            }
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = superTypes = typeHierarchy.getAllSuperclasses(type);
            int n3 = superTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod[] methods;
                IType t = iTypeArray[n4];
                IMethod[] iMethodArray2 = methods = t.getMethods();
                int n5 = methods.length;
                int n6 = 0;
                while (n6 < n5) {
                    IMethod m = iMethodArray2[n6];
                    if (methodName.equals(m.getElementName())) {
                        return m;
                    }
                    ++n6;
                }
                ++n4;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static class MethodDefinition {
        private final IMethod m_method;
        private final Set<String> m_dependsongroups = new HashSet<String>();
        private final Set<MethodDefinition> m_dependsonmethods = new HashSet<MethodDefinition>();

        public MethodDefinition(IMethod method) {
            this.m_method = method;
        }

        public void addDependencyGroups(List<String> dependsOnGroups) {
            if (dependsOnGroups != null && !dependsOnGroups.isEmpty()) {
                this.m_dependsongroups.addAll(dependsOnGroups);
            }
        }

        public void addDependencyMethod(MethodDefinition md) {
            this.m_dependsonmethods.add(md);
        }

        public IMethod getMethod() {
            return this.m_method;
        }

        public String getKey() {
            return this.m_method.getKey();
        }

        public Set<String> getGroups() {
            return this.m_dependsongroups;
        }
    }
}

