/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.TestFinder;
import org.testng.eclipse.launch.components.Filters;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.TypeParser;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.SuiteFileValidator;

public class TestSearchEngine {
    private static Map s_isTestCache = new HashMap();

    public static IType[] findTestNGTests(IRunnableContext context, final IJavaElement element) throws InvocationTargetException, InterruptedException {
        final HashSet result = Sets.newHashSet();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InterruptedException, InvocationTargetException {
                try {
                    new TestFinder().findTestsInContainer(element, result, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        context.run(true, true, runnable);
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] findTests(IRunnableContext context, final Object[] elements, final Filters.ITypeFilter filter) throws InvocationTargetException, InterruptedException {
        final HashSet result = Sets.newHashSet();
        if (elements.length != 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindTests(elements, result, pm, filter);
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static String[] findPackages(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = Sets.newHashSet();
        if (elements.length != 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindPackages(elements, result, pm);
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] findMethods(IRunnableContext context, final Object[] elements, final String className) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length != 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindMethods(elements, result, pm, className);
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new String[result.size()]);
    }

    public static IFile[] findSuites(IRunnableContext context, final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length != 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindSuites(elements, result, pm);
                }
            };
            context.run(true, true, runnable);
        }
        return result.toArray(new IFile[result.size()]);
    }

    public static IFile[] findSuites(final Object[] elements) throws InterruptedException, InvocationTargetException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindSuites(elements, result, pm);
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        return result.toArray(new IFile[result.size()]);
    }

    public static IType[] findTests(final Object[] elements, final Filters.ITypeFilter filter) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindTests(elements, result, pm, filter);
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] findPackages(final Object[] elements) throws InvocationTargetException, InterruptedException {
        final HashSet result = new HashSet();
        if (elements.length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    TestSearchEngine.doFindPackages(elements, result, pm);
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static boolean isTest(IJavaElement ije) {
        boolean result;
        Boolean cachedResult = (Boolean)s_isTestCache.get(ije);
        if (cachedResult != null && cachedResult.booleanValue()) {
            return true;
        }
        try {
            result = 9 == ije.getElementType() ? TestSearchEngine.doIsTest((IMethod)ije) : (5 == ije.getElementType() ? TestSearchEngine.doIsTest((ICompilationUnit)ije) : (7 == ije.getElementType() ? TestSearchEngine.doIsTest((IType)ije) : false));
        }
        catch (JavaModelException jme) {
            TestNGPlugin.log(jme);
            return false;
        }
        if (result) {
            s_isTestCache.put(ije, Boolean.TRUE);
        }
        return result;
    }

    private static boolean doIsTest(IMethod iMethod) {
        ITestContent content = TypeParser.parseType(iMethod.getDeclaringType());
        if (content.hasTestMethods()) {
            return content.isTestMethod(iMethod);
        }
        return false;
    }

    private static boolean doIsTest(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IType[] types;
        IType[] iTypeArray = types = iCompilationUnit.getAllTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (TestSearchEngine.doIsTest(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean doIsTest(IType iType) throws JavaModelException {
        IType[] superclasses;
        if (Flags.isAbstract((int)iType.getFlags())) {
            return false;
        }
        ITestContent testContent = TypeParser.parseType(iType);
        if (testContent.hasTestMethods()) {
            return true;
        }
        try {
            superclasses = iType.newSupertypeHierarchy(null).getAllSuperclasses(iType);
        }
        catch (JavaModelException javaModelException) {
            TestNGPlugin.log("Could not resolve supertype of " + iType.getFullyQualifiedName());
            return false;
        }
        IType[] iTypeArray = superclasses;
        int n = superclasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType superclass = iTypeArray[n2];
            ITestContent superContent = TypeParser.parseType(superclass);
            if (superContent.hasTestMethods()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void doFindTests(Object[] elements, Set result, IProgressMonitor pm, Filters.ITypeFilter filter) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(ResourceUtil.getString("TestSearchEngine.message.searching"), nElements);
        int i = 0;
        while (i < nElements) {
            try {
                TestSearchEngine.collectTypes(elements[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result, filter);
            }
            catch (CoreException e) {
                TestNGPlugin.log(e.getStatus());
            }
            if (pm.isCanceled()) {
                throw new InterruptedException();
            }
            ++i;
        }
    }

    private static void doFindPackages(Object[] elements, Set result, IProgressMonitor pm) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(ResourceUtil.getString("TestSearchEngine.message.searching"), nElements);
        try {
            int i = 0;
            while (i < nElements) {
                if (elements[i] instanceof IJavaElement) {
                    TestSearchEngine.findPackages((IJavaElement)((IJavaElement)elements[i]).getJavaProject(), result);
                }
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            pm.done();
        }
    }

    private static void doFindMethods(Object[] elements, Set result, IProgressMonitor pm, String className) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(ResourceUtil.getString("TestSearchEngine.message.searching"), nElements);
        try {
            int i = 0;
            while (i < nElements) {
                if (elements[i] instanceof IJavaElement) {
                    TestSearchEngine.findMethods((IJavaElement)((IJavaElement)elements[i]).getJavaProject(), result, className);
                }
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            pm.done();
        }
    }

    private static boolean isTestNgXmlFile(IFile f) {
        String fileExtension = f.getFileExtension();
        if (!"xml".equals(fileExtension) && !"yaml".equals(fileExtension)) {
            return false;
        }
        try {
            return SuiteFileValidator.isSuiteDefinition(f);
        }
        catch (CoreException ce) {
            TestNGPlugin.log(ce);
            return false;
        }
    }

    private static void doFindSuites(Object[] elements, Set<IFile> result, IProgressMonitor pm) throws InterruptedException {
        int nElements = elements.length;
        pm.beginTask(ResourceUtil.getString("TestSearchEngine.message.searching"), nElements);
        try {
            int i = 0;
            while (i < nElements) {
                if (elements[i] instanceof IJavaProject) {
                    TestSearchEngine.findSuites((IContainer)((IJavaProject)elements[i]).getProject(), result);
                }
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            pm.done();
        }
    }

    private static void findSuites(IContainer ires, Set<IFile> results) {
        if (ires == null) {
            return;
        }
        try {
            IResource[] children;
            IResource[] iResourceArray = children = ires.members();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile) {
                    if (TestSearchEngine.isTestNgXmlFile((IFile)res)) {
                        results.add((IFile)res);
                    }
                } else {
                    TestSearchEngine.findSuites((IContainer)res, results);
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            TestNGPlugin.log(ce);
        }
    }

    public static void findFile(IContainer container, String fileName, Set<String> outResult) {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r.getFullPath().toOSString().endsWith(fileName)) {
                    outResult.add(r.getFullPath().toOSString());
                } else if (r instanceof IContainer) {
                    TestSearchEngine.findFile((IContainer)r, fileName, outResult);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void collectTypes(Object element, IProgressMonitor pm, Set<IType> result, Filters.ITypeFilter filter) throws CoreException {
        TestSearchEngine.collectTypes(element, pm, result, filter, null);
    }

    public static void collectTypes(Object element, IProgressMonitor pm, Set<IType> result, Filters.ITypeFilter filter, String message) throws CoreException {
        element = TestSearchEngine.computeScope(element);
        if (message == null) {
            message = ResourceUtil.getString("TestSearchEngine.message.searching");
        }
        while (element instanceof ISourceReference && !(element instanceof ICompilationUnit)) {
            if (element instanceof IType && filter.accept((IType)element)) {
                result.add((IType)element);
                return;
            }
            element = ((IJavaElement)element).getParent();
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] types = cu.getAllTypes();
            int i = 0;
            while (i < types.length) {
                pm.worked(1);
                if (filter.accept(types[i])) {
                    result.add(types[i]);
                }
                ++i;
            }
        } else if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot pfr = (IPackageFragmentRoot)element;
            IJavaElement[] iJavaElementArray = pfr.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement javaElement = iJavaElementArray[n2];
                TestSearchEngine.collectTypes(javaElement, pm, result, filter);
                ++n2;
            }
        } else if (element instanceof IPackageFragment) {
            IPackageFragment pfr = (IPackageFragment)element;
            IJavaElement[] iJavaElementArray = pfr.getChildren();
            int n = iJavaElementArray.length;
            int n3 = 0;
            while (n3 < n) {
                IJavaElement javaElement = iJavaElementArray[n3];
                TestSearchEngine.collectTypes(javaElement, pm, result, filter);
                ++n3;
            }
        } else if (element instanceof IJavaElement) {
            TestSearchEngine.findTestTypes(pm, (IJavaElement)((IJavaElement)element).getJavaProject(), result, filter);
        }
    }

    public static void findTestTypes(IProgressMonitor pm, IJavaElement ije, Set<IType> result, Filters.ITypeFilter filter) {
        int i;
        if (4 > ije.getElementType()) {
            try {
                IJavaElement[] children = ((IParent)ije).getChildren();
                i = 0;
                while (i < children.length) {
                    pm.worked(1);
                    TestSearchEngine.findTestTypes(pm, children[i], result, filter);
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
        if (4 == ije.getElementType()) {
            try {
                ICompilationUnit[] compilationUnits = ((IPackageFragment)ije).getCompilationUnits();
                i = 0;
                while (i < compilationUnits.length) {
                    pm.worked(1);
                    TestSearchEngine.findTestTypes(pm, (IJavaElement)compilationUnits[i], result, filter);
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
        if (5 == ije.getElementType()) {
            try {
                IType[] types = ((ICompilationUnit)ije).getAllTypes();
                i = 0;
                while (i < types.length) {
                    if (filter.accept(types[i])) {
                        pm.worked(1);
                        result.add(types[i]);
                    }
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
    }

    private static void findPackages(IJavaElement ije, Set result) {
        int i;
        if (4 > ije.getElementType()) {
            try {
                IJavaElement[] children = ((IParent)ije).getChildren();
                i = 0;
                while (i < children.length) {
                    TestSearchEngine.findPackages(children[i], result);
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
        if (4 == ije.getElementType()) {
            try {
                ICompilationUnit[] compilationUnits = ((IPackageFragment)ije).getCompilationUnits();
                i = 0;
                while (i < compilationUnits.length) {
                    TestSearchEngine.findPackages((IJavaElement)compilationUnits[i], result);
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
        if (5 == ije.getElementType()) {
            try {
                IType[] types = ((ICompilationUnit)ije).getAllTypes();
                i = 0;
                while (i < types.length) {
                    IPackageDeclaration[] pkg;
                    if (Filters.SINGLE_TEST.accept(types[i]) && (pkg = ((ICompilationUnit)ije).getPackageDeclarations()).length > 0) {
                        result.add(pkg[0].getElementName());
                    }
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
    }

    private static void findMethods(IJavaElement ije, Set result, String className) {
        int i;
        if (4 > ije.getElementType()) {
            try {
                IJavaElement[] children = ((IParent)ije).getChildren();
                if (children.length == 0) {
                    return;
                }
                i = 0;
                while (i < children.length) {
                    TestSearchEngine.findMethods(children[i], result, className);
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
        if (4 == ije.getElementType()) {
            try {
                ICompilationUnit[] compilationUnits = ((IPackageFragment)ije).getCompilationUnits();
                if (compilationUnits.length == 0) {
                    return;
                }
                i = 0;
                while (i < compilationUnits.length) {
                    TestSearchEngine.findMethods((IJavaElement)compilationUnits[i], result, className);
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
        if (5 == ije.getElementType()) {
            try {
                IType[] types = ((ICompilationUnit)ije).getAllTypes();
                i = 0;
                while (i < types.length) {
                    Object classType;
                    if (Filters.SINGLE_TEST.accept(types[i]) && (classType = 7 == types[i].getElementType() ? types[i] : (6 == types[i].getElementType() ? ((IClassFile)types[i]).findPrimaryType() : null)) != null && (className.equals("") || classType.getFullyQualifiedName().equals(className))) {
                        IMethod[] methods = classType.getMethods();
                        int j = 0;
                        while (j < methods.length) {
                            if (TypeParser.parseType(classType).isTestMethod(methods[j])) {
                                result.add(String.valueOf(methods[j].getDeclaringType().getFullyQualifiedName()) + "." + methods[j].getElementName());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log(jme);
            }
        }
    }

    private static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        if (element instanceof IClassFile) {
            IClassFile cf = (IClassFile)element;
            element = cf.getType();
        }
        return element;
    }

    public static void ppp(String s) {
        System.out.println("[TestSearchEngine] " + s);
    }
}

